/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractNotificationBrokerTest;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.OpendaylightMdsalBindingTestListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TwoLevelListChanged;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TwoLevelListChangedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardedNotificationAdapterTest
extends AbstractNotificationBrokerTest {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardedNotificationAdapterTest.class);

    @Override
    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return Set.of(BindingReflections.getModuleInfo(TwoLevelListChanged.class));
    }

    @Test
    public void testPutSubscription() throws InterruptedException {
        TestNotifListener listener = new TestNotifListener(1);
        try (ListenerRegistration reg = this.getNotificationService().registerNotificationListener((NotificationListener)listener);){
            this.assertPutSubscription(listener);
        }
    }

    @Test
    public void testPutSubscriptionSimple() throws InterruptedException {
        SimpleNotifListener listener = new SimpleNotifListener(1);
        try (Registration reg = this.getNotificationService().registerListener(TwoLevelListChanged.class, (NotificationService.Listener)listener);){
            this.assertPutSubscription(listener);
        }
    }

    private void assertPutSubscription(AbstractNotifListener listener) throws InterruptedException {
        TwoLevelListChanged testData = ForwardedNotificationAdapterTest.createTestData();
        this.getNotificationPublishService().putNotification((Notification)testData);
        List<TwoLevelListChanged> received = listener.awaitNotifications();
        Assert.assertEquals((long)1L, (long)received.size());
        Assert.assertSame((Object)testData, (Object)received.get(0));
    }

    @Test
    public void testOfferSubscription() throws InterruptedException {
        TestNotifListener listener = new TestNotifListener(1);
        try (ListenerRegistration reg = this.getNotificationService().registerNotificationListener((NotificationListener)listener);){
            this.assertOfferNotification(listener);
        }
    }

    @Test
    public void testOfferSubscriptionSimple() throws InterruptedException {
        SimpleNotifListener listener = new SimpleNotifListener(1);
        try (Registration reg = this.getNotificationService().registerListener(TwoLevelListChanged.class, (NotificationService.Listener)listener);){
            this.assertOfferNotification(listener);
        }
    }

    private void assertOfferNotification(AbstractNotifListener listener) throws InterruptedException {
        TwoLevelListChanged testData = ForwardedNotificationAdapterTest.createTestData();
        try {
            this.getNotificationPublishService().offerNotification((Notification)testData).get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new AssertionError("Notification should be delivered", e);
        }
        List<TwoLevelListChanged> received = listener.awaitNotifications();
        Assert.assertEquals((long)1L, (long)received.size());
        Assert.assertSame((Object)testData, (Object)received.get(0));
    }

    @Test
    public void testOfferTimedNotification() throws InterruptedException {
        TestNotifListener listener = new TestNotifListener(1);
        try (ListenerRegistration reg = this.getNotificationService().registerNotificationListener((NotificationListener)listener);){
            this.assertOfferTimedNotification(listener);
        }
    }

    @Test
    public void testOfferTimedNotificationSimple() throws InterruptedException {
        SimpleNotifListener listener = new SimpleNotifListener(1);
        try (Registration reg = this.getNotificationService().registerListener(TwoLevelListChanged.class, (NotificationService.Listener)listener);){
            this.assertOfferTimedNotification(listener);
        }
    }

    private void assertOfferTimedNotification(AbstractNotifListener listener) throws InterruptedException {
        TwoLevelListChanged testData = ForwardedNotificationAdapterTest.createTestData();
        Assert.assertNotSame((Object)NotificationPublishService.REJECTED, (Object)this.getNotificationPublishService().offerNotification((Notification)testData, 5, TimeUnit.SECONDS));
        List<TwoLevelListChanged> received = listener.awaitNotifications();
        Assert.assertEquals((long)1L, (long)received.size());
        Assert.assertSame((Object)testData, (Object)received.get(0));
    }

    private static @NonNull TwoLevelListChanged createTestData() {
        return new TwoLevelListChangedBuilder().setTopLevelList(BindingMap.of((Identifiable)new TopLevelListBuilder().withKey(new TopLevelListKey("test")).build())).build();
    }

    private static class TestNotifListener
    extends AbstractNotifListener
    implements OpendaylightMdsalBindingTestListener {
        TestNotifListener(int expectedCount) {
            super(expectedCount);
        }

        public void onTwoLevelListChanged(TwoLevelListChanged notification) {
            this.receiveNotification(notification);
        }
    }

    private static abstract class AbstractNotifListener {
        private final List<TwoLevelListChanged> receivedNotifications = new ArrayList<TwoLevelListChanged>();
        private final CountDownLatch latch;

        AbstractNotifListener(int expectedCount) {
            this.latch = new CountDownLatch(expectedCount);
        }

        final void receiveNotification(TwoLevelListChanged notification) {
            this.receivedNotifications.add(notification);
            this.latch.countDown();
        }

        final List<TwoLevelListChanged> awaitNotifications() throws InterruptedException {
            this.latch.await();
            return this.receivedNotifications;
        }
    }

    private static class SimpleNotifListener
    extends AbstractNotifListener
    implements NotificationService.Listener<TwoLevelListChanged> {
        SimpleNotifListener(int expectedCount) {
            super(expectedCount);
        }

        public void onNotification(TwoLevelListChanged notification) {
            this.receiveNotification(notification);
        }
    }
}

