/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class WriteTransactionTest
extends AbstractDataBrokerTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    private static final TopLevelListKey TOP_LIST_KEY = new TopLevelListKey("foo");
    private static final InstanceIdentifier<TopLevelList> NODE_PATH = TOP_PATH.child(TopLevelList.class, (Identifier)TOP_LIST_KEY);
    private static final TopLevelList NODE = new TopLevelListBuilder().withKey(TOP_LIST_KEY).build();

    @Test
    public void test() throws InterruptedException, ExecutionException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        writeTx.put(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE);
        writeTx.commit().get();
    }

    @Test
    public void testPutCreateParentsSuccess() throws InterruptedException, ExecutionException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructurePut(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE);
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional topNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, TOP_PATH).get();
        Assert.assertTrue((String)"Top node must exists after commit", (boolean)topNode.isPresent());
        Optional listNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, NODE_PATH).get();
        Assert.assertTrue((String)"List node must exists after commit", (boolean)listNode.isPresent());
    }

    @Test
    public void testPutCreateParentsSuperfluous() throws InterruptedException, ExecutionException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructurePut(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        writeTx.commit().get();
    }

    @Test
    public void testMergeCreateParentsSuccess() throws InterruptedException, ExecutionException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructureMerge(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE);
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional topNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, TOP_PATH).get();
        Assert.assertTrue((String)"Top node must exists after commit", (boolean)topNode.isPresent());
        Optional listNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, NODE_PATH).get();
        Assert.assertTrue((String)"List node must exists after commit", (boolean)listNode.isPresent());
    }

    @Test
    public void testMergeCreateParentsSuperfluous() throws InterruptedException, ExecutionException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructurePut(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        writeTx.commit().get();
    }
}

