/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.QueryReadTransaction;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryFactory;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQueryFactory;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeFactory;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.Foo;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.FooBuilder;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.first.grp.System;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.first.grp.SystemBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPerformanceTest
extends AbstractDataBrokerTest {
    private static final Logger LOG = LoggerFactory.getLogger(QueryPerformanceTest.class);
    private static final int SYSTEM_COUNT = 1000000;
    private static Foo FOO;
    private QueryFactory factory;

    @BeforeClass
    public static void beforeClass() {
        Stopwatch sw = Stopwatch.createStarted();
        BindingMap.Builder builder = BindingMap.builder((int)1000000);
        for (int i = 0; i < 1000000; ++i) {
            builder.add((Identifiable)new SystemBuilder().setName("name" + i).setAlias("alias" + i).build());
        }
        FOO = new FooBuilder().setSystem(builder.build()).build();
        LOG.info("Test data with {} items built in {}", (Object)1000000, (Object)sw);
    }

    @AfterClass
    public static void afterClass() {
        FOO = null;
    }

    @Override
    protected void setupWithRuntimeContext(BindingRuntimeContext runtimeContext) {
        super.setupWithRuntimeContext(runtimeContext);
        this.factory = new DefaultQueryFactory(ServiceLoader.load(BindingCodecTreeFactory.class).findFirst().orElseThrow().create(runtimeContext));
    }

    @Override
    protected void setupWithDataBroker(DataBroker dataBroker) {
        Stopwatch sw = Stopwatch.createStarted();
        WriteTransaction wtx = dataBroker.newWriteOnlyTransaction();
        wtx.put(LogicalDatastoreType.CONFIGURATION, InstanceIdentifier.create(Foo.class), (DataObject)FOO);
        QueryPerformanceTest.assertCommit(wtx.commit());
        LOG.info("Test data with {} items populated in {}", (Object)1000000, (Object)sw);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void queryLessThanAlarm() throws InterruptedException, ExecutionException {
        FluentFuture future;
        String needle = "alias999999";
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class).matching().leaf(System::getAlias).valueEquals((Object)"alias999999").build();
        LOG.info("Query built in {}", (Object)sw);
        sw.reset().start();
        try (ReadTransaction rtx = this.getDataBroker().newReadOnlyTransaction();){
            MatcherAssert.assertThat((Object)rtx, (Matcher)CoreMatchers.instanceOf(QueryReadTransaction.class));
            future = ((QueryReadTransaction)rtx).execute(LogicalDatastoreType.CONFIGURATION, query);
        }
        @NonNull QueryResult result = (QueryResult)future.get();
        LOG.info("Query executed {} in {}", (Object)future, (Object)sw);
        Assert.assertTrue((boolean)result.stream().findAny().isPresent());
        LOG.info("Query result in {}", (Object)sw);
    }

    @Test
    public void searchLessThanAlarm() throws InterruptedException, ExecutionException {
        FluentFuture future;
        String needle = "alias999999";
        Stopwatch sw = Stopwatch.createStarted();
        try (ReadTransaction rtx = this.getDataBroker().newReadOnlyTransaction();){
            future = rtx.read(LogicalDatastoreType.CONFIGURATION, InstanceIdentifier.create(Foo.class));
        }
        Foo haystack = (Foo)((Optional)future.get()).orElseThrow();
        LOG.info("Read executed in {}", (Object)sw);
        System result = null;
        for (System system : haystack.nonnullSystem().values()) {
            if (!"alias999999".equals(system.getAlias())) continue;
            result = system;
            break;
        }
        LOG.info("Search found {} in {}", result, (Object)sw);
        Assert.assertNotNull(result);
    }
}

