/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.test;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import org.junit.Before;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public abstract class AbstractSchemaAwareTest {
    private static final LoadingCache<Set<YangModuleInfo>, BindingRuntimeContext> RUNTIME_CONTEXT_CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Set<YangModuleInfo>, BindingRuntimeContext>(){

        public BindingRuntimeContext load(Set<YangModuleInfo> key) {
            return BindingRuntimeHelpers.createRuntimeContext(key);
        }
    });

    @Before
    public final void setup() throws Exception {
        this.setupWithRuntimeContext(this.getRuntimeContext());
    }

    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return BindingReflections.cacheModuleInfos((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    protected BindingRuntimeContext getRuntimeContext() throws Exception {
        return (BindingRuntimeContext)RUNTIME_CONTEXT_CACHE.getUnchecked(this.getModuleInfos());
    }

    protected EffectiveModelContext getSchemaContext() throws Exception {
        return this.getRuntimeContext().getEffectiveModelContext();
    }

    protected void setupWithRuntimeContext(BindingRuntimeContext runtimeContext) {
        this.setupWithSchema(runtimeContext.getEffectiveModelContext());
    }

    protected void setupWithSchema(EffectiveModelContext context) {
    }
}

