/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.test.tests;

import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.mdsal.binding.test.model.util.ListsBindingUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeComplexUsesAugmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.complex.from.grouping.ContainerWithUsesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AbstractDataBrokerTestTest
extends AbstractConcurrentDataBrokerTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);

    @Before
    public void before() {
        Assert.assertNotNull((Object)this.getDataBroker());
    }

    @Test
    public void aEnsureDataBrokerIsNotNull() {
        Assert.assertNotNull((Object)this.getDataBroker());
    }

    @Test
    public void bPutSomethingIntoDataStore() throws Exception {
        this.writeInitialState();
        Assert.assertTrue((boolean)this.isTopInDataStore());
    }

    @Test
    public void cEnsureDataStoreIsEmptyAgainInNewTest() throws Exception {
        Assert.assertFalse((boolean)this.isTopInDataStore());
    }

    private void writeInitialState() throws InterruptedException, ExecutionException {
        WriteTransaction initialTx = this.getDataBroker().newWriteOnlyTransaction();
        initialTx.put(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        TreeComplexUsesAugment fooAugment = new TreeComplexUsesAugmentBuilder().setContainerWithUses(new ContainerWithUsesBuilder().setLeafFromGrouping("foo").build()).build();
        initialTx.put(LogicalDatastoreType.OPERATIONAL, ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY), (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, (TreeComplexUsesAugment)fooAugment));
        initialTx.commit().get();
    }

    private boolean isTopInDataStore() throws InterruptedException, ExecutionException {
        try (ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();){
            boolean bl = (Boolean)readTx.exists(LogicalDatastoreType.OPERATIONAL, TOP_PATH).get();
            return bl;
        }
    }
}

