/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.test.util;

import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.EventListener;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMSchemaServiceExtension;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;

public final class MockSchemaService
implements DOMSchemaService,
EffectiveModelContextProvider,
AdapterContext {
    private static final LoadingCache<BindingRuntimeContext, BindingDOMCodecServices> CODEC_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<BindingRuntimeContext, BindingDOMCodecServices>(){

        public BindingDOMCodecServices load(BindingRuntimeContext key) {
            return new BindingCodecContext(key);
        }
    });
    private EffectiveModelContext schemaContext;
    private CurrentAdapterSerializer serializer;
    final ListenerRegistry<EffectiveModelContextListener> listeners = ListenerRegistry.create();

    public synchronized EffectiveModelContext getGlobalContext() {
        return this.schemaContext;
    }

    public ListenerRegistration<EffectiveModelContextListener> registerSchemaContextListener(EffectiveModelContextListener listener) {
        return this.listeners.register((EventListener)listener);
    }

    public synchronized EffectiveModelContext getEffectiveModelContext() {
        return this.schemaContext;
    }

    public ClassToInstanceMap<DOMSchemaServiceExtension> getExtensions() {
        return ImmutableClassToInstanceMap.of();
    }

    public synchronized void changeSchema(BindingRuntimeContext newContext) {
        this.serializer = new CurrentAdapterSerializer((BindingDOMCodecServices)CODEC_CACHE.getUnchecked((Object)newContext));
        this.schemaContext = newContext.getEffectiveModelContext();
        this.listeners.streamListeners().forEach(listener -> listener.onModelContextUpdated(this.schemaContext));
    }

    public synchronized CurrentAdapterSerializer currentSerializer() {
        return (CurrentAdapterSerializer)Verify.verifyNotNull((Object)this.serializer);
    }
}

