/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedNotification;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.yangtools.yang.binding.BaseNotification;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

abstract class AbstractDOMNotificationListenerAdapter
implements DOMNotificationListener {
    private final AdapterContext adapterContext;

    AbstractDOMNotificationListenerAdapter(AdapterContext adapterContext) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
    }

    public final void onNotification(DOMNotification notification) {
        this.onNotification(notification.getType(), (Notification)Verify.verifyNotNull(this.deserialize(notification)));
    }

    abstract void onNotification(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute var1, @NonNull Notification<?> var2);

    abstract Set<SchemaNodeIdentifier.Absolute> getSupportedNotifications();

    private Notification<?> deserialize(DOMNotification notification) {
        if (notification instanceof LazySerializedNotification) {
            return (Notification)((LazySerializedNotification)notification).getBindingData();
        }
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        BaseNotification result = notification instanceof DOMEvent ? serializer.fromNormalizedNodeNotification(notification.getType(), notification.getBody(), ((DOMEvent)notification).getEventInstant()) : serializer.fromNormalizedNodeNotification(notification.getType(), notification.getBody());
        Verify.verify((boolean)(result instanceof Notification), (String)"Unexpected codec result %s", (Object)result);
        return (Notification)result;
    }
}

