/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeChangeService;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.TransactionChainListener;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeChangeServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMReadTransactionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMReadWriteTransactionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMTransactionChainAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMWriteTransactionAdapter;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;

@VisibleForTesting
public class BindingDOMDataBrokerAdapter
extends AbstractBindingAdapter<DOMDataBroker>
implements DataBroker,
DataTreeChangeService {
    static final BindingDOMAdapterBuilder.Factory<DataBroker> BUILDER_FACTORY = Builder::new;
    private final DataTreeChangeService treeChangeService;

    public BindingDOMDataBrokerAdapter(AdapterContext adapterContext, DOMDataBroker domDataBroker) {
        super(adapterContext, domDataBroker);
        DOMDataTreeChangeService domTreeChange = (DOMDataTreeChangeService)domDataBroker.getExtensions().getInstance(DOMDataTreeChangeService.class);
        this.treeChangeService = domTreeChange == null ? null : new BindingDOMDataTreeChangeServiceAdapter(adapterContext, domTreeChange);
    }

    public ReadTransaction newReadOnlyTransaction() {
        return new BindingDOMReadTransactionAdapter(this.adapterContext(), ((DOMDataBroker)this.getDelegate()).newReadOnlyTransaction());
    }

    public WriteTransaction newWriteOnlyTransaction() {
        return new BindingDOMWriteTransactionAdapter<DOMDataTreeWriteTransaction>(this.adapterContext(), ((DOMDataBroker)this.getDelegate()).newWriteOnlyTransaction());
    }

    public ReadWriteTransaction newReadWriteTransaction() {
        return new BindingDOMReadWriteTransactionAdapter(this.adapterContext(), ((DOMDataBroker)this.getDelegate()).newReadWriteTransaction());
    }

    public TransactionChain createTransactionChain(TransactionChainListener listener) {
        return new BindingDOMTransactionChainAdapter(arg_0 -> ((DOMDataBroker)((DOMDataBroker)this.getDelegate())).createTransactionChain(arg_0), this.adapterContext(), listener);
    }

    public TransactionChain createMergingTransactionChain(TransactionChainListener listener) {
        return new BindingDOMTransactionChainAdapter(arg_0 -> ((DOMDataBroker)((DOMDataBroker)this.getDelegate())).createMergingTransactionChain(arg_0), this.adapterContext(), listener);
    }

    public <T extends DataObject, L extends DataTreeChangeListener<T>> ListenerRegistration<L> registerDataTreeChangeListener(DataTreeIdentifier<T> treeId, L listener) {
        if (this.treeChangeService == null) {
            throw new UnsupportedOperationException("Underlying data broker does not expose DOMDataTreeChangeService.");
        }
        return this.treeChangeService.registerDataTreeChangeListener(treeId, listener);
    }

    private static class Builder
    extends BindingDOMAdapterBuilder<DataBroker> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMDataBroker.class);
        }

        @Override
        protected DataBroker createInstance(ClassToInstanceMap<DOMService> delegates) {
            return new BindingDOMDataBrokerAdapter(this.adapterContext(), (DOMDataBroker)delegates.getInstance(DOMDataBroker.class));
        }
    }
}

