/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.InstanceNotificationSpec;
import org.opendaylight.mdsal.binding.dom.adapter.ContextReferenceExtractor;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.binding.dom.codec.spi.ForwardingBindingDOMCodecServices;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.InputRuntimeType;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@VisibleForTesting
public final class CurrentAdapterSerializer
extends ForwardingBindingDOMCodecServices {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentAdapterSerializer.class);
    @Deprecated
    private static final MethodType RPC_SERVICE_METHOD_SIGNATURE = MethodType.methodType(ListenableFuture.class, RpcService.class, RpcInput.class);
    private final LoadingCache<InstanceIdentifier<?>, YangInstanceIdentifier> cache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<InstanceIdentifier<?>, YangInstanceIdentifier>(){

        public YangInstanceIdentifier load(InstanceIdentifier<?> key) {
            return CurrentAdapterSerializer.this.toYangInstanceIdentifier(key);
        }
    });
    private final ConcurrentMap<JavaTypeName, ContextReferenceExtractor> extractors = new ConcurrentHashMap<JavaTypeName, ContextReferenceExtractor>();
    @Deprecated
    private final ConcurrentMap<Class<? extends RpcService>, ImmutableMap<QName, MethodHandle>> rpcMethods = new ConcurrentHashMap<Class<? extends RpcService>, ImmutableMap<QName, MethodHandle>>();
    private final @NonNull BindingDOMCodecServices delegate;

    public CurrentAdapterSerializer(BindingDOMCodecServices delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected BindingDOMCodecServices delegate() {
        return this.delegate;
    }

    @NonNull YangInstanceIdentifier toCachedYangInstanceIdentifier(@NonNull InstanceIdentifier<?> path) {
        return (YangInstanceIdentifier)this.cache.getUnchecked(path);
    }

    <T extends DataObject> @NonNull InstanceIdentifier<T> coerceInstanceIdentifier(YangInstanceIdentifier dom) {
        return (InstanceIdentifier)Verify.verifyNotNull((Object)this.fromYangInstanceIdentifier(dom));
    }

    DOMDataTreeIdentifier toDOMDataTreeIdentifier(DataTreeIdentifier<?> path) {
        return new DOMDataTreeIdentifier(path.getDatastoreType(), this.toYangInstanceIdentifier(path.getRootIdentifier()));
    }

    Collection<DOMDataTreeIdentifier> toDOMDataTreeIdentifiers(Collection<DataTreeIdentifier<?>> subtrees) {
        return subtrees.stream().map(this::toDOMDataTreeIdentifier).collect(Collectors.toSet());
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute getActionPath(@NonNull ActionSpec<?, ?> spec) {
        Map.Entry<SchemaInferenceStack, QNameModule> entry = this.resolvePath(spec.path());
        SchemaInferenceStack stack = entry.getKey();
        SchemaTreeEffectiveStatement stmt = stack.enterSchemaTree(BindingReflections.findQName((Class)spec.type()).bindTo(entry.getValue()));
        Verify.verify((boolean)(stmt instanceof ActionEffectiveStatement), (String)"Action %s resolved to unexpected statement %s", spec, (Object)stmt);
        return stack.toSchemaNodeIdentifier();
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute getNotificationPath(@NonNull InstanceNotificationSpec<?, ?> spec) {
        Map.Entry<SchemaInferenceStack, QNameModule> entry = this.resolvePath(spec.path());
        SchemaInferenceStack stack = entry.getKey();
        SchemaTreeEffectiveStatement stmt = stack.enterSchemaTree(BindingReflections.findQName((Class)spec.type()).bindTo(entry.getValue()));
        Verify.verify((boolean)(stmt instanceof NotificationEffectiveStatement), (String)"Notification %s resolved to unexpected statement %s", spec, (Object)stmt);
        return stack.toSchemaNodeIdentifier();
    }

    @Nullable ContextReferenceExtractor findExtractor(@NonNull InputRuntimeType inputType) {
        Class inputClass;
        JavaTypeName inputName = inputType.getIdentifier();
        ContextReferenceExtractor cached = (ContextReferenceExtractor)this.extractors.get(inputName);
        if (cached != null) {
            return cached;
        }
        try {
            inputClass = this.getRuntimeContext().loadClass(inputName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to load class for " + inputType, e);
        }
        ContextReferenceExtractor created = ContextReferenceExtractor.of(inputClass);
        if (created == null) {
            return null;
        }
        ContextReferenceExtractor raced = this.extractors.putIfAbsent(inputName, created);
        return raced != null ? raced : created;
    }

    @Deprecated
    @NonNull ImmutableMap<QName, MethodHandle> getRpcMethods(@NonNull Class<? extends RpcService> serviceType) {
        return this.rpcMethods.computeIfAbsent(serviceType, ignored -> {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            return ImmutableMap.copyOf((Map)Maps.transformValues(this.createQNameToMethod(serviceType), method -> {
                MethodHandle raw;
                try {
                    raw = lookup.unreflect((Method)method);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Lookup on public method failed", e);
                }
                return raw.asType(RPC_SERVICE_METHOD_SIGNATURE);
            }));
        });
    }

    @Deprecated
    @VisibleForTesting
    ImmutableMap<QName, Method> createQNameToMethod(Class<? extends RpcService> key) {
        QNameModule moduleName = BindingReflections.getQNameModule(key);
        BindingRuntimeContext runtimeContext = this.getRuntimeContext();
        Module module = runtimeContext.getEffectiveModelContext().findModule(moduleName).orElse(null);
        if (module == null) {
            LOG.trace("Schema for {} is not available; expected module name: {}; BindingRuntimeContext: {}", new Object[]{key, moduleName, runtimeContext});
            throw new IllegalStateException(String.format("Schema for %s is not available; expected module name: %s; full BindingRuntimeContext available in trace log", key, moduleName));
        }
        ImmutableBiMap.Builder ret = ImmutableBiMap.builder();
        try {
            for (RpcDefinition rpcDef : module.getRpcs()) {
                QName rpcName = rpcDef.getQName();
                ret.put((Object)rpcName, (Object)key.getMethod(BindingMapping.getRpcMethodName((QName)rpcName), runtimeContext.getRpcInput(rpcName)));
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Rpc defined in model does not have representation in generated class.", e);
        }
        return ret.build();
    }

    private @NonNull Map.Entry<SchemaInferenceStack, QNameModule> resolvePath(@NonNull InstanceIdentifier<?> path) {
        QNameModule lastNamespace;
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)this.getRuntimeContext().getEffectiveModelContext());
        Iterator it = this.toYangInstanceIdentifier(path).getPathArguments().iterator();
        Verify.verify((boolean)it.hasNext(), (String)"Unexpected empty instance identifier for %s", path);
        do {
            YangInstanceIdentifier.PathArgument arg;
            if ((arg = (YangInstanceIdentifier.PathArgument)it.next()) instanceof YangInstanceIdentifier.AugmentationIdentifier) {
                Set augChildren = ((YangInstanceIdentifier.AugmentationIdentifier)arg).getPossibleChildNames();
                Verify.verify((!augChildren.isEmpty() ? 1 : 0) != 0, (String)"Invalid empty augmentation %s", (Object)arg);
                lastNamespace = ((QName)augChildren.iterator().next()).getModule();
                continue;
            }
            QName qname = arg.getNodeType();
            DataTreeEffectiveStatement stmt = stack.enterDataTree(qname);
            lastNamespace = qname.getModule();
            if (!(stmt instanceof ListEffectiveStatement)) continue;
            Verify.verify((boolean)it.hasNext(), (String)"Unexpected list termination at %s in %s", (Object)stmt, path);
            YangInstanceIdentifier.PathArgument skipped = (YangInstanceIdentifier.PathArgument)it.next();
            Verify.verify((boolean)(skipped instanceof YangInstanceIdentifier.NodeIdentifier), (String)"Unexpected skipped list entry item %s in %s", (Object)skipped, path);
            Verify.verify((boolean)((QName)stmt.argument()).equals((Object)skipped.getNodeType()), (String)"Mismatched list entry item %s in %s", (Object)skipped, path);
        } while (it.hasNext());
        return Map.entry(stack, lastNamespace);
    }
}

