/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FutureSchema
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FutureSchema.class);
    private final @GuardedBy(value={"postponedOperations"}) Set<FutureSchemaPredicate> postponedOperations = new LinkedHashSet<FutureSchemaPredicate>();
    private final long duration;
    private final TimeUnit unit;
    private volatile BindingRuntimeContext runtimeContext;

    FutureSchema(long time, TimeUnit unit) {
        this.duration = time;
        this.unit = Objects.requireNonNull(unit);
    }

    static FutureSchema create(long time, TimeUnit unit, boolean waitEnabled) {
        return waitEnabled ? new Waiting(time, unit) : new NonWaiting(time, unit);
    }

    BindingRuntimeContext runtimeContext() {
        BindingRuntimeContext localRuntimeContext = this.runtimeContext;
        if (localRuntimeContext != null) {
            return localRuntimeContext;
        }
        if (this.waitForSchema(Collections.emptyList())) {
            return this.runtimeContext;
        }
        throw new IllegalStateException("No SchemaContext is available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRuntimeContextUpdated(BindingRuntimeContext context) {
        Set<FutureSchemaPredicate> set = this.postponedOperations;
        synchronized (set) {
            this.runtimeContext = context;
            for (FutureSchemaPredicate op : this.postponedOperations) {
                op.unlockIfPossible(context);
            }
        }
    }

    long getDuration() {
        return this.duration;
    }

    TimeUnit getUnit() {
        return this.unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Set<FutureSchemaPredicate> set = this.postponedOperations;
        synchronized (set) {
            this.postponedOperations.forEach(FutureSchemaPredicate::cancel);
        }
    }

    boolean waitForSchema(final QNameModule module) {
        return this.addPostponedOpAndWait(new FutureSchemaPredicate(){

            @Override
            public boolean test(BindingRuntimeContext input) {
                return input.getEffectiveModelContext().findModule(module).isPresent();
            }
        });
    }

    boolean waitForSchema(final Collection<Class<?>> bindingClasses) {
        return this.addPostponedOpAndWait(new FutureSchemaPredicate(){

            @Override
            public boolean test(BindingRuntimeContext context) {
                return bindingClasses.stream().allMatch(clz -> {
                    if (Augmentation.class.isAssignableFrom((Class<?>)clz)) {
                        return context.getAugmentationDefinition(clz.asSubclass(Augmentation.class)) != null;
                    }
                    return context.getSchemaDefinition(clz) != null;
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addPostponedOpAndWait(FutureSchemaPredicate postponedOp) {
        Set<FutureSchemaPredicate> set = this.postponedOperations;
        synchronized (set) {
            this.postponedOperations.add(postponedOp);
            BindingRuntimeContext context = this.runtimeContext;
            if (context != null) {
                postponedOp.unlockIfPossible(context);
            }
        }
        return postponedOp.waitForSchema();
    }

    private static final class Waiting
    extends FutureSchema {
        Waiting(long time, TimeUnit unit) {
            super(time, unit);
        }
    }

    private static final class NonWaiting
    extends FutureSchema {
        NonWaiting(long time, TimeUnit unit) {
            super(time, unit);
        }

        @Override
        boolean addPostponedOpAndWait(FutureSchemaPredicate postponedOp) {
            return false;
        }
    }

    private abstract class FutureSchemaPredicate
    implements Predicate<BindingRuntimeContext> {
        private final SettableFuture<Void> schemaPromise = SettableFuture.create();

        private FutureSchemaPredicate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean waitForSchema() {
            try {
                this.schemaPromise.get(FutureSchema.this.duration, FutureSchema.this.unit);
                boolean bl = true;
                return bl;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
            catch (TimeoutException e) {
                LOG.trace("Wait for {} timed out", this.schemaPromise, (Object)e);
                boolean bl = false;
                return bl;
            }
            finally {
                Set<FutureSchemaPredicate> set = FutureSchema.this.postponedOperations;
                synchronized (set) {
                    FutureSchema.this.postponedOperations.remove(this);
                }
            }
        }

        final void unlockIfPossible(BindingRuntimeContext context) {
            if (!this.schemaPromise.isDone() && this.test(context)) {
                this.schemaPromise.set(null);
            }
        }

        final void cancel() {
            this.schemaPromise.cancel(true);
        }
    }
}

