/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.query.ValueMatch;
import org.opendaylight.mdsal.binding.api.query.ValueMatchBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultValueMatch;
import org.opendaylight.mdsal.binding.dom.adapter.query.QueryBuilderState;
import org.opendaylight.mdsal.dom.api.query.DOMQueryPredicate;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

abstract class AbstractValueMatchBuilder<T extends DataObject, V>
implements ValueMatchBuilder<T, V> {
    private final QueryBuilderState builder;
    private final InstanceIdentifier<T> select;
    private final QueryBuilderState.BoundMethod method;

    AbstractValueMatchBuilder(QueryBuilderState builder, InstanceIdentifier<T> select, QueryBuilderState.BoundMethod method) {
        this.builder = Objects.requireNonNull(builder);
        this.select = Objects.requireNonNull(select);
        this.method = Objects.requireNonNull(method);
    }

    public final ValueMatch<T> nonNull() {
        return this.withMatch(DOMQueryPredicate.Match.exists());
    }

    public final ValueMatch<T> isNull() {
        return this.withMatch(DOMQueryPredicate.Match.exists().negate());
    }

    public final ValueMatch<T> valueEquals(V value) {
        return this.withMatch(DOMQueryPredicate.Match.valueEquals(value));
    }

    final YangInstanceIdentifier relativePath() {
        return this.method.parentPath.node(((DataSchemaNode)this.method.methodCodec.getSchema()).getQName());
    }

    final @NonNull ValueMatch<T> withMatch(DOMQueryPredicate.Match match) {
        this.builder.addPredicate(DOMQueryPredicate.of((YangInstanceIdentifier)this.relativePath(), (DOMQueryPredicate.Match)match));
        return new DefaultValueMatch<T>(this.builder, this.select);
    }
}

