/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.query.MatchBuilderPath;
import org.opendaylight.yangtools.concepts.Immutable;

final class LambdaDecoder {
    private static final LoadingCache<Class<?>, Method> REPLACE_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build(new CacheLoader<Class<?>, Method>(){

        public Method load(Class<?> key) throws PrivilegedActionException {
            return AccessController.doPrivileged(() -> {
                Method method = key.getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(true);
                return method;
            });
        }
    });
    private static final LoadingCache<MatchBuilderPath.LeafReference<?, ?>, LambdaTarget> LAMBDA_CACHE = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<MatchBuilderPath.LeafReference<?, ?>, LambdaTarget>(){

        public LambdaTarget load(MatchBuilderPath.LeafReference<?, ?> ref) throws Exception {
            Object replaced = ((Method)REPLACE_CACHE.get(ref.getClass())).invoke(ref, new Object[0]);
            Verify.verify((boolean)(replaced instanceof SerializedLambda), (String)"Unexpected replaced object %s", (Object)replaced);
            SerializedLambda serialized = (SerializedLambda)replaced;
            return new LambdaTarget(serialized.getImplClass().replace('/', '.'), serialized.getImplMethodName());
        }
    });

    private LambdaDecoder() {
    }

    static LambdaTarget resolveLambda(MatchBuilderPath.LeafReference<?, ?> lambda) {
        return (LambdaTarget)LAMBDA_CACHE.getUnchecked(lambda);
    }

    static final class LambdaTarget
    implements Immutable {
        final String targetClass;
        final String targetMethod;

        LambdaTarget(String targetClass, String targetMethod) {
            this.targetClass = Objects.requireNonNull(targetClass);
            this.targetMethod = Objects.requireNonNull(targetMethod);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("class", (Object)this.targetClass).add("method", (Object)this.targetMethod).toString();
        }
    }
}

