/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.mdsal.binding.api.ActionService;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractActionAdapterTest;
import org.opendaylight.mdsal.binding.dom.adapter.ActionServiceAdapter;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.SimpleDOMActionResult;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.Cont;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.Lstio;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.LstioKey;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.cont.Foo;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.lstio.Fooio;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ActionServiceAdapterTest
extends AbstractActionAdapterTest {
    @Mock
    private DOMActionService delegate;
    private ActionService service;
    private SettableFuture<DOMActionResult> domResult;

    @Override
    @Before
    public void before() {
        super.before();
        this.domResult = SettableFuture.create();
        ((DOMActionService)Mockito.doReturn(this.domResult).when((Object)this.delegate)).invokeAction((SchemaNodeIdentifier.Absolute)ArgumentMatchers.any(), (DOMDataTreeIdentifier)ArgumentMatchers.any(), (ContainerNode)ArgumentMatchers.any());
        this.service = new ActionServiceAdapter(this.codec, this.delegate);
    }

    @Test
    public void testInvocation() throws ExecutionException {
        Foo handle = (Foo)this.service.getActionHandle(ActionSpec.builder(Cont.class).build(Foo.class));
        ListenableFuture future = handle.invoke(InstanceIdentifier.create(Cont.class), BINDING_FOO_INPUT);
        Assert.assertNotNull((Object)future);
        Assert.assertFalse((boolean)future.isDone());
        this.domResult.set((Object)new SimpleDOMActionResult(DOM_FOO_OUTPUT, List.of()));
        RpcResult bindingResult = (RpcResult)Futures.getDone((Future)future);
        Assert.assertEquals(List.of(), (Object)bindingResult.getErrors());
        Assert.assertEquals((Object)BINDING_FOO_OUTPUT, (Object)bindingResult.getResult());
    }

    @Test
    public void testKeyedInvocation() throws ExecutionException {
        Fooio handle = (Fooio)this.service.getActionHandle(ActionSpec.builder(Lstio.class).build(Fooio.class));
        ListenableFuture future = handle.invoke(InstanceIdentifier.builder(Lstio.class, (Key)new LstioKey("test")).build(), BINDING_LSTIO_INPUT);
        Assert.assertNotNull((Object)future);
        Assert.assertFalse((boolean)future.isDone());
        this.domResult.set((Object)new SimpleDOMActionResult(DOM_FOO_OUTPUT, List.of()));
        RpcResult bindingResult = (RpcResult)Futures.getDone((Future)future);
        Assert.assertEquals(List.of(), (Object)bindingResult.getErrors());
        Assert.assertEquals((Object)BINDING_LSTIO_OUTPUT, (Object)bindingResult.getResult());
    }
}

