/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterLoader;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataBrokerAdapter;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.yang.gen.v1.bug8449.rev170516.Top;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class BindingDOMAdapterLoaderTest {
    @Mock
    private DOMDataBroker domService;
    @Mock
    private AdapterContext mockContext;
    @Mock
    private DOMTransactionChain domChain;
    private BindingDOMAdapterLoader bindingDOMAdapterLoader;

    @Before
    public void setUp() {
        this.bindingDOMAdapterLoader = new BindingDOMAdapterLoader(this.mockContext){

            protected DOMService<?, ?> getDelegate(Class<? extends DOMService<?, ?>> reqDeleg) {
                return BindingDOMAdapterLoaderTest.this.domService;
            }
        };
    }

    @Test
    public void createBuilderTest() {
        this.assertDataBrokerAdapter();
        this.domService = null;
        Assert.assertEquals(Optional.empty(), (Object)this.bindingDOMAdapterLoader.load(DataBroker.class));
    }

    @Test
    public void createChainTest() {
        BindingDOMDataBrokerAdapter adapter = this.assertDataBrokerAdapter();
        ((DOMDataBroker)Mockito.doReturn((Object)this.domChain).when((Object)this.domService)).createTransactionChain();
        Assert.assertNotNull((Object)adapter.createTransactionChain());
    }

    @Test
    public void registerWithException() {
        BindingDOMDataBrokerAdapter adapter = this.assertDataBrokerAdapter();
        UnsupportedOperationException ex = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> adapter.registerDataTreeChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)InstanceIdentifier.create(Top.class)), (DataTreeChangeListener)Mockito.mock(DataTreeChangeListener.class)));
        Assert.assertEquals((Object)"Underlying data broker does not expose DOMDataTreeChangeService.", (Object)ex.getMessage());
    }

    private BindingDOMDataBrokerAdapter assertDataBrokerAdapter() {
        BindingService service = (BindingService)this.bindingDOMAdapterLoader.load(DataBroker.class).orElseThrow();
        MatcherAssert.assertThat((Object)service, (Matcher)CoreMatchers.instanceOf(BindingDOMDataBrokerAdapter.class));
        return (BindingDOMDataBrokerAdapter)service;
    }
}

