/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeChangeServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ConstantAdapterContext;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@ExtendWith(value={MockitoExtension.class})
class BindingDOMDataTreeChangeServiceAdapterTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    private static final YangInstanceIdentifier TOP_YIID = YangInstanceIdentifier.of((QName)Top.QNAME);
    @Mock
    private DOMDataBroker.DataTreeChangeExtension mockDOMService;
    @Mock
    private BindingDOMCodecServices services;
    @Mock
    private Registration mockDOMReg;

    BindingDOMDataTreeChangeServiceAdapterTest() {
    }

    @BeforeEach
    public void setUp() {
        ((BindingDOMCodecServices)Mockito.doReturn((Object)TOP_YIID).when((Object)this.services)).toYangInstanceIdentifier(TOP_PATH);
    }

    @Test
    void testRegisterDataTreeChangeListener() {
        ConstantAdapterContext codec = new ConstantAdapterContext(this.services);
        BindingDOMDataTreeChangeServiceAdapter service = new BindingDOMDataTreeChangeServiceAdapter((AdapterContext)codec, this.mockDOMService);
        ((DOMDataBroker.DataTreeChangeExtension)Mockito.doReturn((Object)this.mockDOMReg).when((Object)this.mockDOMService)).registerTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(TOP_YIID), (DOMDataTreeChangeListener)ArgumentMatchers.any());
        DataTreeIdentifier treeId = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, TOP_PATH);
        service.registerDataTreeChangeListener(treeId, (ClusteredDataTreeChangeListener)new TestClusteredDataTreeChangeListener());
        ((DOMDataBroker.DataTreeChangeExtension)Mockito.doReturn((Object)this.mockDOMReg).when((Object)this.mockDOMService)).registerLegacyTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(TOP_YIID), (DOMDataTreeChangeListener)ArgumentMatchers.any());
        service.registerDataTreeChangeListener(treeId, (DataTreeChangeListener)new TestDataTreeChangeListener());
    }

    private static @NonNull DOMDataTreeIdentifier domDataTreeIdentifier(YangInstanceIdentifier yangID) {
        return (DOMDataTreeIdentifier)ArgumentMatchers.argThat(arg -> arg.datastore() == LogicalDatastoreType.CONFIGURATION && yangID.equals((Object)arg.path()));
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    private static final class TestClusteredDataTreeChangeListener
    implements ClusteredDataTreeChangeListener<Top> {
        private TestClusteredDataTreeChangeListener() {
        }

        public void onDataTreeChanged(List<DataTreeModification<Top>> changes) {
        }
    }

    private static final class TestDataTreeChangeListener
    implements DataTreeChangeListener<Top> {
        private TestDataTreeChangeListener() {
        }

        public void onDataTreeChanged(List<DataTreeModification<Top>> changes) {
        }
    }
}

