/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.opendaylight.mdsal.binding.api.DataTreeCommitCohort;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeCommitCohortRegistryAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingBrokerTestFactory;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingTestContext;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

@ExtendWith(value={MockitoExtension.class})
public class BindingDOMDataTreeCommitCohortRegistryAdapterTest {
    @Mock
    private DOMDataBroker.CommitCohortExtension cohortExtension;
    @Mock
    private Registration cohortRegistration;
    @Mock
    private DataTreeCommitCohort<Top> dataTreeCommitCohort;

    @Test
    void basicTest() {
        BindingBrokerTestFactory bindingBrokerTestFactory = new BindingBrokerTestFactory();
        bindingBrokerTestFactory.setExecutor((ExecutorService)MoreExecutors.newDirectExecutorService());
        BindingTestContext bindingTestContext = bindingBrokerTestFactory.getTestContext();
        bindingTestContext.start();
        ((DOMDataBroker.CommitCohortExtension)Mockito.doReturn((Object)this.cohortRegistration).when((Object)this.cohortExtension)).registerCommitCohort((DOMDataTreeIdentifier)ArgumentMatchers.any(), (DOMDataTreeCommitCohort)ArgumentMatchers.any());
        ((Registration)Mockito.doNothing().when((Object)this.cohortRegistration)).close();
        BindingDOMDataTreeCommitCohortRegistryAdapter registryAdapter = new BindingDOMDataTreeCommitCohortRegistryAdapter(bindingTestContext.getCodec(), this.cohortExtension);
        DataTreeIdentifier dataTreeIdentifier = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)InstanceIdentifier.create(Top.class));
        Registration reg = registryAdapter.registerCommitCohort(dataTreeIdentifier, this.dataTreeCommitCohort);
        if (reg != null) {
            reg.close();
        }
    }
}

