/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.api.RpcService;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingBrokerTestFactory;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingTestContext;
import org.opendaylight.mdsal.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.md.sal.knock.knock.rev180723.KnockKnock;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.md.sal.knock.knock.rev180723.KnockKnockInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.md.sal.knock.knock.rev180723.KnockKnockInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.md.sal.knock.knock.rev180723.KnockKnockOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.md.sal.knock.knock.rev180723.KnockKnockOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

public class BindingDOMRpcIntegrationTest {
    private static final InstanceIdentifier<TopLevelList> BA_NODE_ID = InstanceIdentifier.create(Top.class).child(TopLevelList.class, (Key)new TopLevelListKey("a"));
    private static final QName KNOCK_KNOCK_QNAME = QName.create((QName)KnockKnockOutput.QNAME, (String)"knock-knock");
    private RpcProviderService baRpcProviderService;
    private RpcService baRpcService;
    private DOMRpcProviderService biRpcProviderService;
    private BindingTestContext testContext;
    private DOMRpcService biRpcService;
    private final KnockKnockImpl knockRpcImpl = new KnockKnockImpl();

    @Before
    public void setup() throws Exception {
        BindingBrokerTestFactory testFactory = new BindingBrokerTestFactory();
        testFactory.setExecutor((ExecutorService)MoreExecutors.newDirectExecutorService());
        this.testContext = testFactory.getTestContext();
        this.testContext.setSchemaModuleInfos((Set<YangModuleInfo>)ImmutableSet.of((Object)BindingRuntimeHelpers.getYangModuleInfo(KnockKnock.class), (Object)BindingRuntimeHelpers.getYangModuleInfo(Top.class)));
        this.testContext.start();
        this.baRpcProviderService = this.testContext.getBindingRpcProviderRegistry();
        this.baRpcService = this.testContext.getBindingRpcService();
        this.biRpcProviderService = this.testContext.getDomRpcRegistry();
        this.biRpcService = this.testContext.getDomRpcInvoker();
    }

    @Test
    public void testBindingRegistrationWithDOMInvocation() throws Exception {
        this.knockRpcImpl.registerTo(this.baRpcProviderService, BA_NODE_ID).setKnockKnockResult(BindingDOMRpcIntegrationTest.knockResult(true, "open"));
        KnockKnock baKnockService = (KnockKnock)this.baRpcService.getRpc(KnockKnock.class);
        Assert.assertNotSame((Object)this.knockRpcImpl, (Object)baKnockService);
        KnockKnockInput baKnockKnockInput = BindingDOMRpcIntegrationTest.knockKnock(BA_NODE_ID).setQuestion("who's there?").build();
        ContainerNode biKnockKnockInput = this.toDOMKnockKnockInput(baKnockKnockInput);
        DOMRpcResult domResult = (DOMRpcResult)Futures.getDone((Future)this.biRpcService.invokeRpc(KNOCK_KNOCK_QNAME, biKnockKnockInput));
        Assert.assertNotNull((Object)domResult);
        Assert.assertNotNull((Object)domResult.value());
        Assert.assertTrue((String)"Binding KnockKnock service was not invoked", (boolean)this.knockRpcImpl.getReceivedKnocks().containsKey(BA_NODE_ID));
        Assert.assertEquals((Object)baKnockKnockInput, this.knockRpcImpl.getReceivedKnocks().get(BA_NODE_ID).iterator().next());
    }

    @Test
    public void testDOMRegistrationWithBindingInvocation() throws Exception {
        KnockKnockOutput baKnockKnockOutput = new KnockKnockOutputBuilder().setAnswer("open").build();
        this.biRpcProviderService.registerRpcImplementation((rpc, input) -> FluentFutures.immediateFluentFuture((Object)new DefaultDOMRpcResult(this.testContext.getCodec().currentSerializer().toNormalizedNodeRpcData((DataContainer)baKnockKnockOutput))), new DOMRpcIdentifier[]{DOMRpcIdentifier.create((QName)KNOCK_KNOCK_QNAME, (YangInstanceIdentifier)this.testContext.getCodec().currentSerializer().toYangInstanceIdentifier(BA_NODE_ID))});
        KnockKnock baKnockService = (KnockKnock)this.baRpcService.getRpc(KnockKnock.class);
        ListenableFuture baResult = baKnockService.invoke(BindingDOMRpcIntegrationTest.knockKnock(BA_NODE_ID).setQuestion("Who's there?").build());
        Assert.assertNotNull((Object)baResult);
        Assert.assertEquals((Object)baKnockKnockOutput, (Object)((RpcResult)Futures.getDone((Future)baResult)).getResult());
    }

    @Test
    public void testBindingRpcShortcut() throws Exception {
        ListenableFuture<RpcResult<KnockKnockOutput>> baKnockResult = BindingDOMRpcIntegrationTest.knockResult(true, "open");
        this.knockRpcImpl.registerTo(this.baRpcProviderService, BA_NODE_ID).setKnockKnockResult(baKnockResult);
        KnockKnock baKnockService = (KnockKnock)this.baRpcService.getRpc(KnockKnock.class);
        KnockKnockInput baKnockKnockInput = BindingDOMRpcIntegrationTest.knockKnock(BA_NODE_ID).setQuestion("who's there?").build();
        RpcResult rpcResult = (RpcResult)Futures.getDone((Future)baKnockService.invoke(baKnockKnockInput));
        Assert.assertEquals(((KnockKnockOutput)((RpcResult)baKnockResult.get()).getResult()).getClass(), ((KnockKnockOutput)rpcResult.getResult()).getClass());
        Assert.assertSame((Object)((RpcResult)baKnockResult.get()).getResult(), (Object)rpcResult.getResult());
        Assert.assertSame((Object)baKnockKnockInput, this.knockRpcImpl.getReceivedKnocks().get(BA_NODE_ID).iterator().next());
    }

    @Test
    public void testSimpleRpc() throws Exception {
        this.baRpcProviderService.registerRpcImplementation((Rpc)((KnockKnock)input -> BindingDOMRpcIntegrationTest.knockResult(true, "open")));
        KnockKnock baKnockService = (KnockKnock)this.baRpcService.getRpc(KnockKnock.class);
        RpcResult rpcResult = (RpcResult)Futures.getDone((Future)baKnockService.invoke(BindingDOMRpcIntegrationTest.knockKnock(BA_NODE_ID).setQuestion("who's there?").build()));
        Assert.assertEquals(((KnockKnockOutput)rpcResult.getResult()).getClass(), ((KnockKnockOutput)rpcResult.getResult()).getClass());
        Assert.assertSame((Object)rpcResult.getResult(), (Object)rpcResult.getResult());
    }

    private static ListenableFuture<RpcResult<KnockKnockOutput>> knockResult(boolean success, String answer) {
        return RpcResultBuilder.status((boolean)success).withResult((Object)new KnockKnockOutputBuilder().setAnswer(answer).build()).buildFuture();
    }

    private static KnockKnockInputBuilder knockKnock(InstanceIdentifier<TopLevelList> listId) {
        KnockKnockInputBuilder builder = new KnockKnockInputBuilder();
        builder.setKnockerId(listId);
        return builder;
    }

    private ContainerNode toDOMKnockKnockInput(KnockKnockInput from) {
        return this.testContext.getCodec().currentSerializer().toNormalizedNodeRpcData((DataContainer)from);
    }

    private static final class KnockKnockImpl
    implements KnockKnock {
        private final Multimap<InstanceIdentifier<?>, KnockKnockInput> receivedKnocks = HashMultimap.create();
        private ListenableFuture<RpcResult<KnockKnockOutput>> knockKnockResult;
        private Registration registration;

        private KnockKnockImpl() {
        }

        KnockKnockImpl setKnockKnockResult(ListenableFuture<RpcResult<KnockKnockOutput>> kkOutput) {
            this.knockKnockResult = kkOutput;
            return this;
        }

        Multimap<InstanceIdentifier<?>, KnockKnockInput> getReceivedKnocks() {
            return this.receivedKnocks;
        }

        KnockKnockImpl registerTo(RpcProviderService registry, InstanceIdentifier<?> ... paths) {
            this.registration = registry.registerRpcImplementation((Rpc)this, (Set)ImmutableSet.copyOf((Object[])paths));
            Assert.assertNotNull((Object)this.registration);
            return this;
        }

        public ListenableFuture<RpcResult<KnockKnockOutput>> invoke(KnockKnockInput input) {
            this.receivedKnocks.put((Object)input.getKnockerId(), (Object)input);
            return this.knockKnockResult;
        }
    }
}

