/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Set;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataTreeChangeListenerTest;
import org.opendaylight.mdsal.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.mdsal.binding.test.model.util.ListsBindingUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.complex.from.grouping.ListViaUsesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

public class Bug1333DataChangeListenerTest
extends AbstractDataTreeChangeListenerTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    private static final InstanceIdentifier<TreeComplexUsesAugment> AUGMENT_WILDCARD = TOP_PATH.child(TopLevelList.class).augmentation(TreeComplexUsesAugment.class);

    @Override
    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return Set.of(BindingRuntimeHelpers.getYangModuleInfo(Top.class), BindingRuntimeHelpers.getYangModuleInfo(TreeComplexUsesAugment.class));
    }

    private static Top topWithListItem() {
        return ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, (Augmentation)ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{ListsBindingUtils.USES_ONE_KEY, ListsBindingUtils.USES_TWO_KEY}))});
    }

    public Top writeTopWithListItem(LogicalDatastoreType store) {
        WriteTransaction tx = this.getDataBroker().newWriteOnlyTransaction();
        Top topItem = Bug1333DataChangeListenerTest.topWithListItem();
        tx.put(store, TOP_PATH, (DataObject)topItem);
        Bug1333DataChangeListenerTest.assertCommit(tx.commit());
        return topItem;
    }

    public void deleteItem(LogicalDatastoreType store, InstanceIdentifier<?> path) {
        WriteTransaction tx = this.getDataBroker().newWriteOnlyTransaction();
        tx.delete(store, path);
        Bug1333DataChangeListenerTest.assertCommit(tx.commit());
    }

    @Test
    public void writeTopWithListItemAugmentedListenTopSubtree() {
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<Top> collector = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_PATH);){
            collector.verifyModifications(new AbstractDataTreeChangeListenerTest.Matcher[0]);
            this.writeTopWithListItem(LogicalDatastoreType.CONFIGURATION);
            collector.verifyModifications(Bug1333DataChangeListenerTest.added(TOP_PATH, Bug1333DataChangeListenerTest.topWithListItem()));
        }
    }

    @Test
    public void writeTopWithListItemAugmentedListenAugmentSubtreeWildcarded() {
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<TreeComplexUsesAugment> collector = this.createCollector(LogicalDatastoreType.CONFIGURATION, AUGMENT_WILDCARD);){
            collector.verifyModifications(new AbstractDataTreeChangeListenerTest.Matcher[0]);
            this.writeTopWithListItem(LogicalDatastoreType.CONFIGURATION);
            collector.verifyModifications(Bug1333DataChangeListenerTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeComplexUsesAugment.class), ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{ListsBindingUtils.USES_ONE_KEY, ListsBindingUtils.USES_TWO_KEY})));
        }
    }

    @Test
    public void deleteAugmentChildListenTopSubtree() {
        Top top = this.writeTopWithListItem(LogicalDatastoreType.CONFIGURATION);
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<Top> collector = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_PATH);){
            collector.verifyModifications(Bug1333DataChangeListenerTest.added(TOP_PATH, top));
            this.deleteItem(LogicalDatastoreType.CONFIGURATION, ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, (ListViaUsesKey)ListsBindingUtils.USES_ONE_KEY));
            collector.verifyModifications(Bug1333DataChangeListenerTest.subtreeModified(TOP_PATH, top, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, (Augmentation)ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{ListsBindingUtils.USES_TWO_KEY}))})));
        }
    }

    @Test
    public void deleteAugmentChildListenAugmentSubtreeWildcarded() {
        this.writeTopWithListItem(LogicalDatastoreType.CONFIGURATION);
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<TreeComplexUsesAugment> collector = this.createCollector(LogicalDatastoreType.CONFIGURATION, AUGMENT_WILDCARD);){
            collector.verifyModifications(Bug1333DataChangeListenerTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeComplexUsesAugment.class), ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{ListsBindingUtils.USES_ONE_KEY, ListsBindingUtils.USES_TWO_KEY})));
            this.deleteItem(LogicalDatastoreType.CONFIGURATION, ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, (ListViaUsesKey)ListsBindingUtils.USES_ONE_KEY));
            collector.verifyModifications(Bug1333DataChangeListenerTest.subtreeModified(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeComplexUsesAugment.class), ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{ListsBindingUtils.USES_ONE_KEY, ListsBindingUtils.USES_TWO_KEY}), ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{ListsBindingUtils.USES_TWO_KEY})));
        }
    }
}

