/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Set;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataTreeChangeListenerTest;
import org.opendaylight.mdsal.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.mdsal.binding.test.model.util.ListsBindingUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeLeafOnlyUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.complex.from.grouping.ListViaUsesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

public class Bug1418AugmentationTest
extends AbstractDataTreeChangeListenerTest {
    private static final InstanceIdentifier<Top> TOP = InstanceIdentifier.create(Top.class);
    private static final InstanceIdentifier<TopLevelList> TOP_FOO = TOP.child(TopLevelList.class, (Key)ListsBindingUtils.TOP_FOO_KEY);
    private static final InstanceIdentifier<TreeLeafOnlyUsesAugment> SIMPLE_AUGMENT = TOP.child(TopLevelList.class, (Key)ListsBindingUtils.TOP_FOO_KEY).augmentation(TreeLeafOnlyUsesAugment.class);
    private static final InstanceIdentifier<TreeComplexUsesAugment> COMPLEX_AUGMENT = TOP.child(TopLevelList.class, (Key)ListsBindingUtils.TOP_FOO_KEY).augmentation(TreeComplexUsesAugment.class);
    private static final ListViaUsesKey LIST_VIA_USES_KEY = new ListViaUsesKey("list key");
    private static final ListViaUsesKey LIST_VIA_USES_KEY_MOD = new ListViaUsesKey("list key modified");

    @Override
    protected Set<YangModuleInfo> getModuleInfos() {
        return Set.of(BindingRuntimeHelpers.getYangModuleInfo(Top.class), BindingRuntimeHelpers.getYangModuleInfo(TreeComplexUsesAugment.class));
    }

    @Test
    public void leafOnlyAugmentationCreatedTest() {
        TreeLeafOnlyUsesAugment leafOnlyUsesAugment = ListsBindingUtils.leafOnlyUsesAugment((String)"test leaf");
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<TreeLeafOnlyUsesAugment> collector = this.createCollector(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT);){
            collector.verifyModifications(new AbstractDataTreeChangeListenerTest.Matcher[0]);
            WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
            writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top());
            writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
            writeTx.put(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, (DataObject)leafOnlyUsesAugment);
            Bug1418AugmentationTest.assertCommit(writeTx.commit());
            collector.verifyModifications(Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugment));
        }
    }

    @Test
    public void leafOnlyAugmentationUpdatedTest() {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top());
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
        TreeLeafOnlyUsesAugment leafOnlyUsesAugmentBefore = ListsBindingUtils.leafOnlyUsesAugment((String)"test leaf");
        writeTx.put(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, (DataObject)leafOnlyUsesAugmentBefore);
        Bug1418AugmentationTest.assertCommit(writeTx.commit());
        TreeLeafOnlyUsesAugment leafOnlyUsesAugmentAfter = ListsBindingUtils.leafOnlyUsesAugment((String)"test leaf changed");
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<TreeLeafOnlyUsesAugment> collector = this.createCollector(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT);){
            collector.verifyModifications(Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugmentBefore));
            writeTx = this.getDataBroker().newWriteOnlyTransaction();
            writeTx.put(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, (DataObject)leafOnlyUsesAugmentAfter);
            Bug1418AugmentationTest.assertCommit(writeTx.commit());
            collector.verifyModifications(Bug1418AugmentationTest.replaced(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugmentBefore, leafOnlyUsesAugmentAfter));
        }
    }

    @Test
    public void leafOnlyAugmentationDeletedTest() {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top());
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
        TreeLeafOnlyUsesAugment leafOnlyUsesAugment = ListsBindingUtils.leafOnlyUsesAugment((String)"test leaf");
        writeTx.put(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, (DataObject)leafOnlyUsesAugment);
        Bug1418AugmentationTest.assertCommit(writeTx.commit());
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<TreeLeafOnlyUsesAugment> collector = this.createCollector(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT);){
            collector.verifyModifications(Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugment));
            writeTx = this.getDataBroker().newWriteOnlyTransaction();
            writeTx.delete(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT);
            Bug1418AugmentationTest.assertCommit(writeTx.commit());
            collector.verifyModifications(Bug1418AugmentationTest.deleted(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugment));
        }
    }

    @Test
    public void complexAugmentationCreatedTest() {
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<TreeComplexUsesAugment> collector = this.createCollector(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT);){
            TreeComplexUsesAugment complexUsesAugment = ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{LIST_VIA_USES_KEY});
            WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
            writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top());
            writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
            writeTx.put(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT, (DataObject)complexUsesAugment);
            Bug1418AugmentationTest.assertCommit(writeTx.commit());
            collector.verifyModifications(Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeComplexUsesAugment.class), complexUsesAugment));
        }
    }

    @Test
    public void complexAugmentationUpdatedTest() {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top());
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
        TreeComplexUsesAugment complexUsesAugmentBefore = ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{LIST_VIA_USES_KEY});
        writeTx.put(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT, (DataObject)complexUsesAugmentBefore);
        Bug1418AugmentationTest.assertCommit(writeTx.commit());
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<TreeComplexUsesAugment> collector = this.createCollector(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT);){
            collector.verifyModifications(Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeComplexUsesAugment.class), complexUsesAugmentBefore));
            TreeComplexUsesAugment complexUsesAugmentAfter = ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{LIST_VIA_USES_KEY_MOD});
            writeTx = this.getDataBroker().newWriteOnlyTransaction();
            writeTx.put(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT, (DataObject)complexUsesAugmentAfter);
            Bug1418AugmentationTest.assertCommit(writeTx.commit());
            collector.verifyModifications(Bug1418AugmentationTest.subtreeModified(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeComplexUsesAugment.class), complexUsesAugmentBefore, complexUsesAugmentAfter));
        }
    }
}

