/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Map;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public class Bug4494Test
extends AbstractDataBrokerTest {
    @Test
    public void testDelete() throws Exception {
        DataBroker dataBroker = this.getDataBroker();
        WriteTransaction writeTransaction = dataBroker.newWriteOnlyTransaction();
        TopLevelList list = new TopLevelListBuilder().setName("name").build();
        TopBuilder builder = new TopBuilder().setTopLevelList(Map.of(list.key(), list));
        writeTransaction.put(LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.create(Top.class), (DataObject)builder.build());
        Bug4494Test.assertCommit(writeTransaction.commit());
        KeyedInstanceIdentifier id = InstanceIdentifier.builder(Top.class).child(TopLevelList.class, (Key)new TopLevelListKey("name")).build();
        ReadWriteTransaction writeTransaction1 = dataBroker.newReadWriteTransaction();
        writeTransaction1.delete(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)id);
        Bug4494Test.assertCommit(writeTransaction1.commit());
        ReadWriteTransaction writeTransaction2 = dataBroker.newReadWriteTransaction();
        writeTransaction2.delete(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)id);
        Bug4494Test.assertCommit(writeTransaction2.commit());
    }
}

