/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.List;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.ListenerTest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.ListenerTestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItem;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItemBuilder;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.Uint32;

@ExtendWith(value={MockitoExtension.class})
class Bug4513Test
extends AbstractDataBrokerTest {
    @Mock
    private DataTreeChangeListener<ListItem> listener;
    @Captor
    private ArgumentCaptor<List<DataTreeModification<ListItem>>> captor;

    Bug4513Test() {
    }

    @Test
    void testDataTreeChangeListener() {
        DataBroker dataBroker = this.getDataBroker();
        InstanceIdentifier wildCard = InstanceIdentifier.builder(ListenerTest.class).child(ListItem.class).build();
        try (Registration reg = dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)wildCard), this.listener);){
            ListItem item = this.writeListItem();
            ((DataTreeChangeListener)Mockito.verify(this.listener, (VerificationMode)Mockito.timeout((long)100L))).onDataTreeChanged((List)this.captor.capture());
            List mods = (List)this.captor.getValue();
            Assertions.assertEquals((int)1, (int)mods.size());
            Assertions.assertEquals((Object)item, (Object)((DataTreeModification)mods.get(0)).getRootNode().dataAfter());
        }
    }

    private ListItem writeListItem() {
        WriteTransaction writeTransaction = this.getDataBroker().newWriteOnlyTransaction();
        ListItem item = new ListItemBuilder().setSip("name").setOp(Uint32.valueOf((int)43)).build();
        writeTransaction.put(LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.create(ListenerTest.class), (DataObject)new ListenerTestBuilder().setListItem(BindingMap.of((KeyAware)item)).build());
        Bug4513Test.assertCommit(writeTransaction.commit());
        return item;
    }
}

