/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.mdsal.binding.dom.adapter.ContextReferenceExtractor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.RockTheHouseInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.rpc.routing.rev140701.EncapsulatedRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.rpc.routing.rev140701.EncapsulatedRouteInGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.rpc.routing.rev140701.RoutedSimpleRouteInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.rpc.routing.rev140701.RoutedSimpleRouteInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class ContextExtractorTest {
    private static final InstanceIdentifier<?> TEST_ROUTE = InstanceIdentifier.create(Top.class);
    private static final Transitive TEST_GROUPING = new Transitive(){

        public Class<? extends Transitive> implementedInterface() {
            return Transitive.class;
        }

        public EncapsulatedRoute getRoute() {
            return new EncapsulatedRoute(TEST_ROUTE);
        }
    };

    @Test
    public void testNonRoutedExtraction() {
        Assert.assertNull((Object)ContextReferenceExtractor.of(RockTheHouseInput.class));
    }

    @Test
    public void testRoutedSimpleExtraction() {
        ContextReferenceExtractor extractor = ContextReferenceExtractor.of(RoutedSimpleRouteInput.class);
        Assert.assertNotNull((Object)extractor);
        MatcherAssert.assertThat((Object)extractor, (Matcher)CoreMatchers.instanceOf(ContextReferenceExtractor.Direct.class));
        Assert.assertSame(TEST_ROUTE, (Object)extractor.extract((DataObject)new RoutedSimpleRouteInputBuilder().setRoute(TEST_ROUTE).build()));
    }

    @Test
    public void testRoutedEncapsulatedExtraction() {
        ContextReferenceExtractor extractor = ContextReferenceExtractor.of(EncapsulatedRouteInGrouping.class);
        Assert.assertNotNull((Object)extractor);
        MatcherAssert.assertThat((Object)extractor, (Matcher)CoreMatchers.instanceOf(ContextReferenceExtractor.GetValue.class));
        Assert.assertSame(TEST_ROUTE, (Object)extractor.extract((DataObject)TEST_GROUPING));
    }

    @Test
    public void testRoutedEncapsulatedTransitiveExtraction() {
        ContextReferenceExtractor extractor = ContextReferenceExtractor.of(Transitive.class);
        Assert.assertNotNull((Object)extractor);
        MatcherAssert.assertThat((Object)extractor, (Matcher)CoreMatchers.instanceOf(ContextReferenceExtractor.GetValue.class));
        Assert.assertSame(TEST_ROUTE, (Object)extractor.extract((DataObject)TEST_GROUPING));
    }

    public static interface Transitive
    extends EncapsulatedRouteInGrouping {
    }
}

