/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.ServiceLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecFactory;
import org.opendaylight.mdsal.binding.generator.impl.DefaultBindingRuntimeGenerator;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.DefaultBindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.test.util.YangParserTestUtils;

public class CurrentAdapterSerializerTest {
    @Test
    public void fromNormalizedNodeTest() throws Exception {
        EffectiveModelContext schemaCtx = YangParserTestUtils.parseYangResource((String)"/test.yang");
        ContainerNode data = CurrentAdapterSerializerTest.prepareData(schemaCtx, Uint16.valueOf((int)42));
        Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode = CurrentAdapterSerializerTest.fromNormalizedNode((NormalizedNode)data, schemaCtx);
        DataObject value = fromNormalizedNode.getValue();
        Assert.assertNotNull((Object)value);
        Class iface = value.implementedInterface();
        Assert.assertEquals((Object)"Cont", (Object)iface.getSimpleName());
        Object[] objs = new Object[]{};
        Object invoked = iface.getDeclaredMethod("getVlanId", new Class[0]).invoke((Object)value, objs);
        Field declaredField = invoked.getClass().getDeclaredField("_id");
        declaredField.setAccessible(true);
        Object id = declaredField.get(invoked);
        Field val = id.getClass().getDeclaredField("_value");
        val.setAccessible(true);
        Assert.assertEquals((Object)Uint16.valueOf((int)42), (Object)val.get(id));
    }

    @Test
    public void fromNormalizedNodeWithAnotherInputDataTest() throws Exception {
        EffectiveModelContext schemaCtx = YangParserTestUtils.parseYangResource((String)"/test.yang");
        ContainerNode data = CurrentAdapterSerializerTest.prepareData(schemaCtx, "42");
        Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode = CurrentAdapterSerializerTest.fromNormalizedNode((NormalizedNode)data, schemaCtx);
        DataObject value = fromNormalizedNode.getValue();
        Assert.assertNotNull((Object)value);
        Class iface = value.implementedInterface();
        Assert.assertEquals((Object)"Cont", (Object)iface.getSimpleName());
        Method getVlanId = iface.getDeclaredMethod("getVlanId", new Class[0]);
        InvocationTargetException ex = (InvocationTargetException)Assert.assertThrows(InvocationTargetException.class, () -> getVlanId.invoke((Object)value, new Object[0]));
        MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
    }

    private static ContainerNode prepareData(EffectiveModelContext schemaCtx, Object value) {
        return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"urn:test", (String)"2017-01-01", (String)"cont"))).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)QName.create((String)"urn:test", (String)"2017-01-01", (String)"vlan-id"), (Object)value)).build();
    }

    private static Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode(NormalizedNode data, EffectiveModelContext schemaCtx) {
        CurrentAdapterSerializer codec = new CurrentAdapterSerializer(ServiceLoader.load(BindingDOMCodecFactory.class).findFirst().orElseThrow().createBindingDOMCodec((BindingRuntimeContext)new DefaultBindingRuntimeContext(new DefaultBindingRuntimeGenerator().generateTypeMapping(schemaCtx), (ModuleInfoSnapshot)TestingModuleInfoSnapshot.INSTANCE)));
        YangInstanceIdentifier path = YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((String)"urn:test", (String)"2017-01-01", (String)"cont")));
        return codec.fromNormalizedNode(path, data);
    }

    private static final class TestingModuleInfoSnapshot
    implements ModuleInfoSnapshot {
        static final TestingModuleInfoSnapshot INSTANCE = new TestingModuleInfoSnapshot();

        private TestingModuleInfoSnapshot() {
        }

        public <T> Class<T> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
            return Class.forName(fullyQualifiedName);
        }

        public YangTextSource yangTextSource(SourceIdentifier arg0) {
            return null;
        }

        public YangTextSource getYangTextSource(SourceIdentifier sourceId) throws MissingSchemaSourceException {
            throw new MissingSchemaSourceException(sourceId, "no sources");
        }

        public EffectiveModelContext modelContext() {
            throw new UnsupportedOperationException();
        }
    }
}

