/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataChangeListener;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.mdsal813.norev.RegisterListenerTest;
import org.opendaylight.yang.gen.v1.mdsal813.norev.RegisterListenerTestBuilder;
import org.opendaylight.yang.gen.v1.mdsal813.norev.register.listener.test.Item;
import org.opendaylight.yang.gen.v1.mdsal813.norev.register.listener.test.ItemBuilder;
import org.opendaylight.yang.gen.v1.mdsal813.norev.register.listener.test.ItemKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.Uint32;

public class DataListenerTest
extends AbstractDataBrokerTest {
    DataBroker dataBroker;
    DataListener<Item> listener;
    DataChangeListener<Item> changeListener;

    @Before
    public void setUp() {
        this.dataBroker = this.getDataBroker();
        this.listener = (DataListener)Mockito.mock(DataListener.class);
        this.changeListener = (DataChangeListener)Mockito.mock(DataChangeListener.class);
    }

    @Test
    public void testThrowExceptionOnRegister() {
        InstanceIdentifier instanceIdentifier = InstanceIdentifier.builder(RegisterListenerTest.class).child(Item.class).build();
        DataTreeIdentifier itemsDataTreeIdentifier = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)instanceIdentifier);
        Throwable dataListenerException = Assert.assertThrows(IllegalArgumentException.class, () -> this.dataBroker.registerDataListener(itemsDataTreeIdentifier, this.listener));
        Assert.assertTrue((boolean)dataListenerException.getMessage().contains("Cannot register listener for wildcard"));
        Throwable dataListenerChangeException = Assert.assertThrows(IllegalArgumentException.class, () -> this.dataBroker.registerDataChangeListener(itemsDataTreeIdentifier, this.changeListener));
        Assert.assertTrue((boolean)dataListenerChangeException.getMessage().contains("Cannot register listener for wildcard"));
    }

    @Test
    public void testRegisterDataListener() {
        Item item = this.writeItems();
        KeyedInstanceIdentifier instanceIdentifier = InstanceIdentifier.builder(RegisterListenerTest.class).child(Item.class, (Key)new ItemKey(item.key())).build();
        this.dataBroker.registerDataListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)instanceIdentifier), this.listener);
        ((DataListener)Mockito.verify(this.listener, (VerificationMode)Mockito.timeout((long)100L))).dataChangedTo((DataObject)item);
    }

    @Test
    public void testRegisterDataChangeListener() {
        Item item = this.writeItems();
        KeyedInstanceIdentifier instanceIdentifier = InstanceIdentifier.builder(RegisterListenerTest.class).child(Item.class, (Key)new ItemKey(item.key())).build();
        this.dataBroker.registerDataChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)instanceIdentifier), this.changeListener);
        ((DataChangeListener)Mockito.verify(this.changeListener, (VerificationMode)Mockito.timeout((long)100L))).dataChanged(null, (DataObject)item);
    }

    private Item writeItems() {
        WriteTransaction writeTransaction = this.getDataBroker().newWriteOnlyTransaction();
        Item wildcardItem = new ItemBuilder().setText("name").setNumber(Uint32.valueOf((int)43)).build();
        RegisterListenerTestBuilder builder = new RegisterListenerTestBuilder().setItem(BindingMap.of((KeyAware)wildcardItem));
        writeTransaction.put(LogicalDatastoreType.CONFIGURATION, InstanceIdentifier.builder(RegisterListenerTest.class).build(), (DataObject)builder.build());
        DataListenerTest.assertCommit(writeTransaction.commit());
        return wildcardItem;
    }
}

