/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.mdsal.binding.dom.adapter.ContextReferenceExtractor;
import org.opendaylight.yang.gen.v1.urn.yang.foo.rev160101.BooleanContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class DirectContextExtractorTest {
    private static final InstanceIdentifier<?> INSTANCE_IDENTIFIER = InstanceIdentifier.create(BooleanContainer.class);
    private static final String EXCEPTION_TEXT = "testException";

    @Test
    public void basicTest() throws Exception {
        ContextReferenceExtractor referenceExtractor = ContextReferenceExtractor.Direct.create((Method)this.getClass().getDeclaredMethod("testMethod", BooleanContainer.class));
        Assert.assertEquals(INSTANCE_IDENTIFIER, (Object)referenceExtractor.extract((DataObject)Mockito.mock(BooleanContainer.class)));
        Assert.assertEquals((Object)EXCEPTION_TEXT, (Object)((NullPointerException)Assert.assertThrows(NullPointerException.class, () -> referenceExtractor.extract(null))).getMessage());
    }

    public static InstanceIdentifier<?> testMethod(BooleanContainer data) {
        if (data == null) {
            throw new NullPointerException(EXCEPTION_TEXT);
        }
        return INSTANCE_IDENTIFIER;
    }
}

