/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractNotificationBrokerTest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TwoLevelListChanged;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TwoLevelListChangedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.YangModuleInfoImpl;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;

public class ForwardedNotificationAdapterTest
extends AbstractNotificationBrokerTest {
    @Override
    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return Set.of(YangModuleInfoImpl.getInstance());
    }

    @Test
    public void testPutSubscription() throws Exception {
        NotifListener listener = new NotifListener(1);
        try (Registration reg = this.getNotificationService().registerListener(TwoLevelListChanged.class, (NotificationService.Listener)listener);){
            TwoLevelListChanged testData = ForwardedNotificationAdapterTest.createTestData();
            this.getNotificationPublishService().putNotification((Notification)testData);
            List<TwoLevelListChanged> received = listener.awaitNotifications();
            Assert.assertEquals((long)1L, (long)received.size());
            Assert.assertSame((Object)testData, (Object)received.get(0));
        }
    }

    @Test
    public void testOfferSubscription() throws Exception {
        NotifListener listener = new NotifListener(1);
        try (Registration reg = this.getNotificationService().registerListener(TwoLevelListChanged.class, (NotificationService.Listener)listener);){
            TwoLevelListChanged testData = ForwardedNotificationAdapterTest.createTestData();
            this.getNotificationPublishService().offerNotification((Notification)testData).get(1L, TimeUnit.SECONDS);
            List<TwoLevelListChanged> received = listener.awaitNotifications();
            Assert.assertEquals((long)1L, (long)received.size());
            Assert.assertSame((Object)testData, (Object)received.get(0));
        }
    }

    @Test
    public void testOfferTimedNotification() throws Exception {
        NotifListener listener = new NotifListener(1);
        try (Registration reg = this.getNotificationService().registerListener(TwoLevelListChanged.class, (NotificationService.Listener)listener);){
            TwoLevelListChanged testData = ForwardedNotificationAdapterTest.createTestData();
            Assert.assertNotSame((Object)NotificationPublishService.REJECTED, (Object)this.getNotificationPublishService().offerNotification((Notification)testData, 5, TimeUnit.SECONDS));
            List<TwoLevelListChanged> received = listener.awaitNotifications();
            Assert.assertEquals((long)1L, (long)received.size());
            Assert.assertSame((Object)testData, (Object)received.get(0));
        }
    }

    private static @NonNull TwoLevelListChanged createTestData() {
        return new TwoLevelListChangedBuilder().setTopLevelList(BindingMap.of((KeyAware)new TopLevelListBuilder().withKey(new TopLevelListKey("test")).build())).build();
    }

    private static final class NotifListener
    implements NotificationService.Listener<TwoLevelListChanged> {
        private final List<TwoLevelListChanged> receivedNotifications = new ArrayList<TwoLevelListChanged>();
        private final CountDownLatch latch;

        NotifListener(int expectedCount) {
            this.latch = new CountDownLatch(expectedCount);
        }

        void receiveNotification(TwoLevelListChanged notification) {
            this.receivedNotifications.add(notification);
            this.latch.countDown();
        }

        List<TwoLevelListChanged> awaitNotifications() throws InterruptedException {
            this.latch.await();
            return this.receivedNotifications;
        }

        public void onNotification(TwoLevelListChanged notification) {
            this.receiveNotification(notification);
        }
    }
}

