/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedContainerNode;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingBrokerTestFactory;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingTestContext;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.RockTheHouseInput;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;

public class LazySerializedContainerNodeTest {
    @Test
    public void basicTest() {
        DataObject dataObject = (DataObject)Mockito.mock(DataObject.class);
        BindingNormalizedNodeSerializer codec = (BindingNormalizedNodeSerializer)Mockito.mock(BindingNormalizedNodeSerializer.class);
        ContainerNode containerNode = (ContainerNode)Mockito.mock(ContainerNode.class);
        ((BindingNormalizedNodeSerializer)Mockito.doReturn((Object)containerNode).when((Object)codec)).toNormalizedNodeRpcData((DataContainer)ArgumentMatchers.any());
        ((ContainerNode)Mockito.doReturn(null).when((Object)containerNode)).childByArg((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifier)ArgumentMatchers.any()));
        BindingBrokerTestFactory bindingBrokerTestFactory = new BindingBrokerTestFactory();
        bindingBrokerTestFactory.setExecutor((ExecutorService)MoreExecutors.newDirectExecutorService());
        BindingTestContext bindingTestContext = bindingBrokerTestFactory.getTestContext();
        bindingTestContext.start();
        YangInstanceIdentifier.NodeIdentifier name = new YangInstanceIdentifier.NodeIdentifier(RockTheHouseInput.QNAME);
        LeafNode leafNode = ImmutableNodes.leafNode((QName)QName.create((String)"", (String)"test"), (Object)"");
        ContainerNode normalizedNode = LazySerializedContainerNode.create((YangInstanceIdentifier.NodeIdentifier)name, (DataObject)dataObject, (BindingNormalizedNodeSerializer)codec);
        Assert.assertNotNull((Object)normalizedNode);
        LazySerializedContainerNode lazySerializedContainerNode = (LazySerializedContainerNode)LazySerializedContainerNode.withContextRef((YangInstanceIdentifier.NodeIdentifier)name, (DataObject)dataObject, (LeafNode)leafNode, (BindingNormalizedNodeSerializer)codec);
        Assert.assertNotNull((Object)lazySerializedContainerNode);
        Assert.assertEquals((Object)leafNode, (Object)lazySerializedContainerNode.childByArg(leafNode.name()));
        Assert.assertNull((Object)lazySerializedContainerNode.childByArg(new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"", (String)"mismatch"))));
        Assert.assertTrue((boolean)lazySerializedContainerNode.body().isEmpty());
        Assert.assertSame((Object)name, (Object)lazySerializedContainerNode.name());
        Assert.assertEquals((Object)dataObject, (Object)lazySerializedContainerNode.getDataObject());
    }
}

