/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataTreeChangeListenerTest;
import org.opendaylight.mdsal.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.mdsal.binding.test.model.util.ListsBindingUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

public class ListInsertionDataChangeListenerTest
extends AbstractDataTreeChangeListenerTest {
    private static final InstanceIdentifier<Top> TOP = InstanceIdentifier.create(Top.class);
    private static final InstanceIdentifier<TopLevelList> WILDCARDED = TOP.child(TopLevelList.class);
    private static final InstanceIdentifier<TopLevelList> TOP_FOO = TOP.child(TopLevelList.class, (Key)ListsBindingUtils.TOP_FOO_KEY);
    private static final InstanceIdentifier<TopLevelList> TOP_BAR = TOP.child(TopLevelList.class, (Key)ListsBindingUtils.TOP_BAR_KEY);

    @Override
    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return Set.of(BindingRuntimeHelpers.getYangModuleInfo(Top.class));
    }

    @Before
    public void setupWithDataBroker() {
        WriteTransaction initialTx = this.getDataBroker().newWriteOnlyTransaction();
        initialTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)}));
        ListInsertionDataChangeListenerTest.assertCommit(initialTx.commit());
    }

    @Test
    public void replaceTopNodeSubtreeListeners() {
        TopLevelList topBar = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
        Top top = ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{topBar});
        TopLevelList topFoo = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<Top> topListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP);){
            try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> allListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, WILDCARDED);){
                try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> fooListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_FOO);){
                    try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> barListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_BAR);){
                        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
                        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)top);
                        ListInsertionDataChangeListenerTest.assertCommit(writeTx.commit());
                        barListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
                    }
                    fooListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.deleted(TOP_FOO, topFoo));
                }
                allListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar), ListInsertionDataChangeListenerTest.deleted(TOP_FOO, topFoo));
            }
            topListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)})), ListInsertionDataChangeListenerTest.replaced(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{topFoo}), top));
        }
    }

    @Test
    public void mergeTopNodeSubtreeListeners() {
        TopLevelList topBar = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
        TopLevelList topFoo = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<Top> topListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP);){
            try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> allListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, WILDCARDED);){
                try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> fooListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_FOO);){
                    try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> barListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_BAR);){
                        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
                        writeTx.merge(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY)}));
                        ListInsertionDataChangeListenerTest.assertCommit(writeTx.commit());
                        barListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
                    }
                    fooListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo));
                }
                allListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
            }
            topListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)})), ListInsertionDataChangeListenerTest.topSubtreeModified(topFoo, topBar));
        }
    }

    @Test
    public void putTopBarNodeSubtreeListeners() {
        TopLevelList topBar = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
        TopLevelList topFoo = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<Top> topListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP);){
            try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> allListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, WILDCARDED);){
                try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> fooListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_FOO);){
                    try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> barListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_BAR);){
                        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
                        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_BAR, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY));
                        ListInsertionDataChangeListenerTest.assertCommit(writeTx.commit());
                        barListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
                    }
                    fooListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo));
                }
                allListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
            }
            topListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)})), ListInsertionDataChangeListenerTest.topSubtreeModified(topFoo, topBar));
        }
    }

    @Test
    public void mergeTopBarNodeSubtreeListeners() {
        TopLevelList topBar = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
        TopLevelList topFoo = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
        try (AbstractDataTreeChangeListenerTest.ModificationCollector<Top> topListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP);){
            try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> allListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, WILDCARDED);){
                try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> fooListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_FOO);){
                    try (AbstractDataTreeChangeListenerTest.ModificationCollector<TopLevelList> barListener = this.createCollector(LogicalDatastoreType.CONFIGURATION, TOP_BAR);){
                        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
                        writeTx.merge(LogicalDatastoreType.CONFIGURATION, TOP_BAR, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY));
                        ListInsertionDataChangeListenerTest.assertCommit(writeTx.commit());
                        barListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
                    }
                    fooListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo));
                }
                allListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
            }
            topListener.verifyModifications(ListInsertionDataChangeListenerTest.added(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)})), ListInsertionDataChangeListenerTest.topSubtreeModified(topFoo, topBar));
        }
    }

    private static AbstractDataTreeChangeListenerTest.Matcher<Top> topSubtreeModified(TopLevelList topFoo, TopLevelList topBar) {
        return ListInsertionDataChangeListenerTest.match(DataObjectModification.ModificationType.SUBTREE_MODIFIED, TOP, dataBefore -> Objects.equals(ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{topFoo}), dataBefore), dataAfter -> {
            HashSet expList = new HashSet(ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{topBar, topFoo}).nonnullTopLevelList().values());
            Set actualList = dataAfter.nonnullTopLevelList().values().stream().map(list -> new TopLevelListBuilder(list).build()).collect(Collectors.toSet());
            return expList.equals(actualList);
        });
    }
}

