/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.AddressableCont;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.AddressableContBuilder;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.Container;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.ContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.UnaddressableCont;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.UnaddressableContBuilder;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.WithChoice;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.WithChoiceBuilder;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.addressable.cont.AddressableChild;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.addressable.cont.AddressableChildBuilder;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.container.Keyed;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.container.KeyedBuilder;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.container.KeyedKey;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.container.Unkeyed;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.container.UnkeyedBuilder;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.with.choice.Foo;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.with.choice.foo.addressable._case.Addressable;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.with.choice.foo.addressable._case.AddressableBuilder;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NodeStep;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;

public class Mdsal298Test
extends AbstractDataBrokerTest {
    private static final InstanceIdentifier<Container> CONTAINER = InstanceIdentifier.create(Container.class);
    private static final DataTreeIdentifier<Container> CONTAINER_TID = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, CONTAINER);
    private static final YangInstanceIdentifier.NodeIdentifier CONTAINER_NID = new YangInstanceIdentifier.NodeIdentifier(Container.QNAME);
    private static final QName FOO_QNAME = QName.create((QName)Container.QNAME, (String)"foo");
    private static final QName BAZ_QNAME = QName.create((QName)UnaddressableCont.QNAME, (String)"baz");
    private static final InstanceIdentifier<WithChoice> CHOICE_CONTAINER = InstanceIdentifier.create(WithChoice.class);
    private static final DataTreeIdentifier<WithChoice> CHOICE_CONTAINER_TID = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, CHOICE_CONTAINER);
    private static final YangInstanceIdentifier.NodeIdentifier CHOICE_CONTAINER_NID = new YangInstanceIdentifier.NodeIdentifier(WithChoice.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier CHOICE_NID = new YangInstanceIdentifier.NodeIdentifier(Foo.QNAME);
    private static final InstanceIdentifier<Addressable> ADDRESSABLE_CASE = CHOICE_CONTAINER.child(Addressable.class);
    private static final InstanceIdentifier<AddressableCont> ADDRESSABLE_CONTAINER = InstanceIdentifier.create(AddressableCont.class);
    private static final DataTreeIdentifier<AddressableCont> ADDRESSABLE_CONTAINER_TID = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, ADDRESSABLE_CONTAINER);
    private static final YangInstanceIdentifier.NodeIdentifier ADDRESSABLE_CONTAINER_NID = new YangInstanceIdentifier.NodeIdentifier(AddressableCont.QNAME);
    private static final InstanceIdentifier<UnaddressableCont> UNADDRESSABLE_CONTAINER = InstanceIdentifier.create(UnaddressableCont.class);
    private static final DataTreeIdentifier<UnaddressableCont> UNADDRESSABLE_CONTAINER_TID = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, UNADDRESSABLE_CONTAINER);
    private static final YangInstanceIdentifier.NodeIdentifier UNADDRESSABLE_CONTAINER_NID = new YangInstanceIdentifier.NodeIdentifier(UnaddressableCont.QNAME);

    @Test
    public void testKeyedDataTreeModification() throws InterruptedException, ExecutionException {
        DataTreeChangeListener<Container> listener = this.assertWrittenContainer(Container.QNAME, Container.class, new ContainerBuilder().build());
        DOMDataTreeWriteTransaction domTx = this.getDomBroker().newWriteOnlyTransaction();
        domTx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)CONTAINER_NID).node(Keyed.QNAME), ImmutableNodes.newUserMapBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(Keyed.QNAME)).addChild((NormalizedNode)((MapEntryNode)ImmutableNodes.newMapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)Keyed.QNAME, (QName)FOO_QNAME, (Object)"foo")).addChild((NormalizedNode)ImmutableNodes.leafNode((QName)FOO_QNAME, (Object)"foo")).build())).addChild((NormalizedNode)((MapEntryNode)ImmutableNodes.newMapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)Keyed.QNAME, (QName)FOO_QNAME, (Object)"bar")).addChild((NormalizedNode)ImmutableNodes.leafNode((QName)FOO_QNAME, (Object)"bar")).build())).build());
        domTx.commit().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((DataTreeChangeListener)Mockito.verify(listener)).onDataTreeChanged((List)captor.capture());
        List capture = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)capture.size());
        DataTreeModification change = (DataTreeModification)capture.get(0);
        Assert.assertEquals(CONTAINER_TID, (Object)change.getRootPath());
        DataObjectModification changedContainer = change.getRootNode();
        Assert.assertEquals((Object)new NodeStep(Container.class), (Object)changedContainer.step());
        Assert.assertEquals((Object)DataObjectModification.ModificationType.SUBTREE_MODIFIED, (Object)changedContainer.modificationType());
        Container containerAfter = (Container)changedContainer.dataAfter();
        Assert.assertEquals((Object)new ContainerBuilder().setKeyed(List.of(new KeyedBuilder().setFoo("foo").withKey(new KeyedKey("foo")).build(), new KeyedBuilder().setFoo("bar").withKey(new KeyedKey("bar")).build())).build(), (Object)containerAfter);
        Collection changedChildren = changedContainer.modifiedChildren();
        Assert.assertEquals((long)2L, (long)changedChildren.size());
        Iterator it = changedChildren.iterator();
        DataObjectModification changedChild1 = (DataObjectModification)it.next();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.WRITE, (Object)changedChild1.modificationType());
        Assert.assertEquals(List.of(), (Object)changedChild1.modifiedChildren());
        Keyed child1After = (Keyed)changedChild1.dataAfter();
        Assert.assertEquals((Object)"foo", (Object)child1After.getFoo());
        DataObjectModification changedChild2 = (DataObjectModification)it.next();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.WRITE, (Object)changedChild2.modificationType());
        Assert.assertEquals(List.of(), (Object)changedChild2.modifiedChildren());
        Keyed child2After = (Keyed)changedChild2.dataAfter();
        Assert.assertEquals((Object)"bar", (Object)child2After.getFoo());
    }

    @Test
    public void testUnkeyedDataTreeModification() throws InterruptedException, ExecutionException {
        DataTreeChangeListener<Container> listener = this.assertWrittenContainer(Container.QNAME, Container.class, new ContainerBuilder().build());
        DOMDataTreeWriteTransaction domTx = this.getDomBroker().newWriteOnlyTransaction();
        domTx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)CONTAINER_NID).node(Unkeyed.QNAME), ImmutableNodes.newUnkeyedListBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(Unkeyed.QNAME)).withChild((NormalizedNode)((UnkeyedListEntryNode)ImmutableNodes.newUnkeyedListEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Unkeyed.QNAME)).addChild((NormalizedNode)ImmutableNodes.leafNode((QName)FOO_QNAME, (Object)"foo")).build())).withChild((NormalizedNode)((UnkeyedListEntryNode)ImmutableNodes.newUnkeyedListEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Unkeyed.QNAME)).addChild((NormalizedNode)ImmutableNodes.leafNode((QName)FOO_QNAME, (Object)"bar")).build())).build());
        domTx.commit().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((DataTreeChangeListener)Mockito.verify(listener)).onDataTreeChanged((List)captor.capture());
        List capture = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)capture.size());
        DataTreeModification change = (DataTreeModification)capture.get(0);
        Assert.assertEquals(CONTAINER_TID, (Object)change.getRootPath());
        DataObjectModification changedContainer = change.getRootNode();
        Assert.assertEquals((Object)new NodeStep(Container.class), (Object)changedContainer.step());
        Assert.assertEquals((Object)DataObjectModification.ModificationType.WRITE, (Object)changedContainer.modificationType());
        Container containerAfter = (Container)changedContainer.dataAfter();
        Assert.assertEquals((Object)new ContainerBuilder().setUnkeyed(List.of(new UnkeyedBuilder().setFoo("foo").build(), new UnkeyedBuilder().setFoo("bar").build())).build(), (Object)containerAfter);
        Collection changedChildren = changedContainer.modifiedChildren();
        Assert.assertEquals((long)0L, (long)changedChildren.size());
    }

    @Test
    public void testChoiceDataTreeModificationAddressable() throws InterruptedException, ExecutionException {
        DataTreeChangeListener<WithChoice> listener = this.assertWrittenWithChoice();
        ((DataTreeChangeListener)Mockito.doNothing().when(listener)).onDataTreeChanged(ArgumentMatchers.anyList());
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, ADDRESSABLE_CASE, (DataObject)new AddressableBuilder().build());
        writeTx.commit().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((DataTreeChangeListener)Mockito.verify(listener)).onDataTreeChanged((List)captor.capture());
        List capture = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)capture.size());
        DataTreeModification choiceChange = (DataTreeModification)capture.iterator().next();
        Assert.assertEquals(CHOICE_CONTAINER_TID, (Object)choiceChange.getRootPath());
        DataObjectModification changedContainer = choiceChange.getRootNode();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.SUBTREE_MODIFIED, (Object)changedContainer.modificationType());
        Assert.assertEquals((Object)new NodeStep(WithChoice.class), (Object)changedContainer.step());
        Collection choiceChildren = changedContainer.modifiedChildren();
        Assert.assertEquals((long)1L, (long)choiceChildren.size());
        DataObjectModification changedCase = (DataObjectModification)choiceChildren.iterator().next();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.WRITE, (Object)changedCase.modificationType());
        Assert.assertEquals((Object)new NodeStep(Addressable.class), (Object)changedCase.step());
        Assert.assertEquals((Object)new AddressableBuilder().build(), (Object)changedCase.dataAfter());
    }

    @Test
    public void testDataTreeModificationAddressable() throws InterruptedException, ExecutionException {
        DataTreeChangeListener<AddressableCont> listener = this.assertWrittenContainer(AddressableCont.QNAME, AddressableCont.class, new AddressableContBuilder().build());
        ((DataTreeChangeListener)Mockito.doNothing().when(listener)).onDataTreeChanged(ArgumentMatchers.anyList());
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, ADDRESSABLE_CONTAINER.child(AddressableChild.class), (DataObject)new AddressableChildBuilder().build());
        writeTx.commit().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((DataTreeChangeListener)Mockito.verify(listener)).onDataTreeChanged((List)captor.capture());
        List capture = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)capture.size());
        DataTreeModification contChange = (DataTreeModification)capture.iterator().next();
        Assert.assertEquals(ADDRESSABLE_CONTAINER_TID, (Object)contChange.getRootPath());
        DataObjectModification changedContainer = contChange.getRootNode();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.SUBTREE_MODIFIED, (Object)changedContainer.modificationType());
        Assert.assertEquals((Object)new NodeStep(AddressableCont.class), (Object)changedContainer.step());
        Collection contChildren = changedContainer.modifiedChildren();
        Assert.assertEquals((long)1L, (long)contChildren.size());
        DataObjectModification changedChild = (DataObjectModification)contChildren.iterator().next();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.WRITE, (Object)changedChild.modificationType());
        Assert.assertEquals((Object)new NodeStep(AddressableChild.class), (Object)changedChild.step());
        Assert.assertEquals((Object)new AddressableChildBuilder().build(), (Object)changedChild.dataAfter());
    }

    @Test
    public void testDataTreeModificationUnaddressable() throws InterruptedException, ExecutionException {
        DataTreeChangeListener<UnaddressableCont> listener = this.assertWrittenContainer(UnaddressableCont.QNAME, UnaddressableCont.class, new UnaddressableContBuilder().build());
        ((DataTreeChangeListener)Mockito.doNothing().when(listener)).onDataTreeChanged(ArgumentMatchers.anyList());
        DOMDataTreeWriteTransaction domTx = this.getDomBroker().newWriteOnlyTransaction();
        domTx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)UNADDRESSABLE_CONTAINER_NID).node(QName.create((QName)UnaddressableCont.QNAME, (String)"baz")), (NormalizedNode)ImmutableNodes.leafNode((QName)BAZ_QNAME, (Object)"baz"));
        domTx.commit().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((DataTreeChangeListener)Mockito.verify(listener)).onDataTreeChanged((List)captor.capture());
        List capture = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)capture.size());
        DataTreeModification contChange = (DataTreeModification)capture.iterator().next();
        Assert.assertEquals(UNADDRESSABLE_CONTAINER_TID, (Object)contChange.getRootPath());
        DataObjectModification changedContainer = contChange.getRootNode();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.WRITE, (Object)changedContainer.modificationType());
        Assert.assertEquals((Object)new NodeStep(UnaddressableCont.class), (Object)changedContainer.step());
        Collection contChildren = changedContainer.modifiedChildren();
        Assert.assertEquals((long)0L, (long)contChildren.size());
    }

    @Test
    public void testChoiceDataTreeModificationUnaddressable() throws InterruptedException, ExecutionException {
        DataTreeChangeListener<WithChoice> listener = this.assertWrittenWithChoice();
        ((DataTreeChangeListener)Mockito.doNothing().when(listener)).onDataTreeChanged(ArgumentMatchers.anyList());
        DOMDataTreeWriteTransaction domTx = this.getDomBroker().newWriteOnlyTransaction();
        domTx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)CHOICE_CONTAINER_NID).node(Foo.QNAME), ImmutableNodes.newChoiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Foo.QNAME)).withChild((DataContainerChild)ImmutableNodes.newSystemLeafSetBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)Foo.QNAME, (String)"unaddressable"))).withChildValue((Object)"foo").build()).build());
        domTx.commit().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((DataTreeChangeListener)Mockito.verify(listener)).onDataTreeChanged((List)captor.capture());
        List capture = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)capture.size());
        DataTreeModification choiceChange = (DataTreeModification)capture.get(0);
        Assert.assertEquals(CHOICE_CONTAINER_TID, (Object)choiceChange.getRootPath());
        DataObjectModification changedContainer = choiceChange.getRootNode();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.WRITE, (Object)changedContainer.modificationType());
        Assert.assertEquals((Object)new NodeStep(WithChoice.class), (Object)changedContainer.step());
        Collection choiceChildren = changedContainer.modifiedChildren();
        Assert.assertEquals((long)0L, (long)choiceChildren.size());
    }

    private <T extends ChildOf<? extends DataRoot>> DataTreeChangeListener<T> assertWrittenContainer(QName qname, Class<T> bindingClass, T expected) throws InterruptedException, ExecutionException {
        DataTreeChangeListener listener = (DataTreeChangeListener)Mockito.mock(DataTreeChangeListener.class);
        ((DataTreeChangeListener)Mockito.doNothing().when((Object)listener)).onDataTreeChanged(ArgumentMatchers.anyList());
        DataTreeIdentifier dti = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)InstanceIdentifier.create(bindingClass));
        this.getDataBroker().registerDataTreeChangeListener(dti, listener);
        DOMDataTreeWriteTransaction domTx = this.getDomBroker().newWriteOnlyTransaction();
        domTx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(qname)), ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(qname)).build());
        domTx.commit().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((DataTreeChangeListener)Mockito.verify((Object)listener)).onDataTreeChanged((List)captor.capture());
        List capture = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)capture.size());
        DataTreeModification change = (DataTreeModification)capture.iterator().next();
        Assert.assertEquals((Object)dti, (Object)change.getRootPath());
        DataObjectModification changedContainer = change.getRootNode();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.WRITE, (Object)changedContainer.modificationType());
        Assert.assertEquals((Object)new NodeStep(bindingClass), (Object)changedContainer.step());
        ChildOf containerAfter = (ChildOf)changedContainer.dataAfter();
        Assert.assertEquals(expected, (Object)containerAfter);
        Assert.assertEquals(List.of(), (Object)changedContainer.modifiedChildren());
        Mockito.reset((Object[])new DataTreeChangeListener[]{listener});
        ((DataTreeChangeListener)Mockito.doNothing().when((Object)listener)).onDataTreeChanged(ArgumentMatchers.anyList());
        return listener;
    }

    private DataTreeChangeListener<WithChoice> assertWrittenWithChoice() throws InterruptedException, ExecutionException {
        DataTreeChangeListener listener = (DataTreeChangeListener)Mockito.mock(DataTreeChangeListener.class);
        ((DataTreeChangeListener)Mockito.doNothing().when((Object)listener)).onDataTreeChanged(ArgumentMatchers.anyList());
        this.getDataBroker().registerDataTreeChangeListener(CHOICE_CONTAINER_TID, listener);
        DOMDataTreeWriteTransaction domTx = this.getDomBroker().newWriteOnlyTransaction();
        domTx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)CHOICE_CONTAINER_NID), ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)CHOICE_CONTAINER_NID).withChild((DataContainerChild)ImmutableNodes.newChoiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)CHOICE_NID).build()).build());
        domTx.commit().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((DataTreeChangeListener)Mockito.verify((Object)listener)).onDataTreeChanged((List)captor.capture());
        List capture = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)capture.size());
        DataTreeModification change = (DataTreeModification)capture.iterator().next();
        Assert.assertEquals(CHOICE_CONTAINER_TID, (Object)change.getRootPath());
        DataObjectModification changedContainer = change.getRootNode();
        Assert.assertEquals((Object)DataObjectModification.ModificationType.WRITE, (Object)changedContainer.modificationType());
        Assert.assertEquals((Object)new NodeStep(WithChoice.class), (Object)changedContainer.step());
        WithChoice containerAfter = (WithChoice)changedContainer.dataAfter();
        Assert.assertEquals((Object)new WithChoiceBuilder().build(), (Object)containerAfter);
        Assert.assertEquals(List.of(), (Object)changedContainer.modifiedChildren());
        Mockito.reset((Object[])new DataTreeChangeListener[]{listener});
        ((DataTreeChangeListener)Mockito.doNothing().when((Object)listener)).onDataTreeChanged(ArgumentMatchers.anyList());
        return listener;
    }
}

