/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.api.RpcService;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingBrokerTestFactory;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingTestContext;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.yang.gen.v1.rpc.norev.Switch;
import org.opendaylight.yang.gen.v1.rpc.norev.SwitchInput;
import org.opendaylight.yang.gen.v1.rpc.norev.SwitchInputBuilder;
import org.opendaylight.yang.gen.v1.rpc.norev.SwitchOutput;
import org.opendaylight.yang.gen.v1.rpc.norev.SwitchOutputBuilder;
import org.opendaylight.yang.svc.v1.rpc.norev.YangModuleInfoImpl;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

public class Mdsal500Test {
    private static final String FOO = "foo";
    private static final QName SWITCH_QNAME = QName.create((QName)SwitchOutput.QNAME, (String)"switch");
    private RpcProviderService baRpcProviderService;
    private RpcService baRpcConsumerService;
    private DOMRpcProviderService biRpcProviderService;
    private BindingTestContext testContext;
    private DOMRpcService biRpcService;
    private final SwitchImpl switchRpcImpl = new SwitchImpl();

    @Before
    public void setup() throws Exception {
        BindingBrokerTestFactory testFactory = new BindingBrokerTestFactory();
        testFactory.setExecutor((ExecutorService)MoreExecutors.newDirectExecutorService());
        this.testContext = testFactory.getTestContext();
        this.testContext.setSchemaModuleInfos(Set.of(YangModuleInfoImpl.getInstance()));
        this.testContext.start();
        this.baRpcProviderService = this.testContext.getBindingRpcProviderRegistry();
        this.baRpcConsumerService = this.testContext.getBindingRpcService();
        this.biRpcProviderService = this.testContext.getDomRpcRegistry();
        this.biRpcService = this.testContext.getDomRpcInvoker();
    }

    @Test
    public void testBindingRegistrationWithDOMInvocation() throws Exception {
        this.switchRpcImpl.registerTo(this.baRpcProviderService).setSwitchResult(Mdsal500Test.switchResult(true));
        Switch baSwitchService = (Switch)this.baRpcConsumerService.getRpc(Switch.class);
        Assert.assertNotSame((Object)this.switchRpcImpl, (Object)baSwitchService);
        SwitchInput baSwitchInput = Mdsal500Test.switchBuilder(FOO).build();
        ContainerNode biSwitchInput = this.toDOMSwitchInput(baSwitchInput);
        DOMRpcResult domResult = (DOMRpcResult)this.biRpcService.invokeRpc(SWITCH_QNAME, biSwitchInput).get(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)domResult);
        Assert.assertNotNull((Object)domResult.value());
        Assert.assertTrue((String)"Binding KnockKnock service was not invoked", (boolean)this.switchRpcImpl.getReceivedSwitch().containsKey((Object)FOO));
        Assert.assertEquals((Object)baSwitchInput, this.switchRpcImpl.getReceivedSwitch().get((Object)FOO).iterator().next());
    }

    @Test
    public void testDOMRegistrationWithBindingInvocation() throws InterruptedException, ExecutionException, TimeoutException {
        SwitchOutput baSwitchOutput = new SwitchOutputBuilder().build();
        this.biRpcProviderService.registerRpcImplementation((rpc, input) -> FluentFutures.immediateFluentFuture((Object)new DefaultDOMRpcResult(this.testContext.getCodec().currentSerializer().toNormalizedNodeRpcData((DataContainer)baSwitchOutput))), new DOMRpcIdentifier[]{DOMRpcIdentifier.create((QName)SWITCH_QNAME)});
        Switch baSwitchService = (Switch)this.baRpcConsumerService.getRpc(Switch.class);
        ListenableFuture baResult = baSwitchService.invoke(Mdsal500Test.switchBuilder(FOO).build());
        Assert.assertNotNull((Object)baResult);
        Assert.assertEquals((Object)baSwitchOutput, (Object)((RpcResult)baResult.get(5L, TimeUnit.SECONDS)).getResult());
    }

    @Test
    public void testBindingRpcShortcut() throws InterruptedException, ExecutionException, TimeoutException {
        ListenableFuture<RpcResult<SwitchOutput>> baSwitchResult = Mdsal500Test.switchResult(true);
        this.switchRpcImpl.registerTo(this.baRpcProviderService).setSwitchResult(baSwitchResult);
        Switch baSwitchService = (Switch)this.baRpcConsumerService.getRpc(Switch.class);
        SwitchInput baSwitchInput = Mdsal500Test.switchBuilder(FOO).build();
        ListenableFuture future = baSwitchService.invoke(baSwitchInput);
        RpcResult rpcResult = (RpcResult)future.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals(((SwitchOutput)((RpcResult)baSwitchResult.get()).getResult()).getClass(), ((SwitchOutput)rpcResult.getResult()).getClass());
        Assert.assertSame((Object)((RpcResult)baSwitchResult.get()).getResult(), (Object)rpcResult.getResult());
        Assert.assertSame((Object)baSwitchInput, this.switchRpcImpl.getReceivedSwitch().get((Object)FOO).iterator().next());
    }

    private static ListenableFuture<RpcResult<SwitchOutput>> switchResult(boolean success) {
        return Futures.immediateFuture((Object)RpcResultBuilder.status((boolean)success).withResult((Object)new SwitchOutputBuilder().build()).build());
    }

    private static SwitchInputBuilder switchBuilder(String foo) {
        return new SwitchInputBuilder().setFoo(foo);
    }

    private ContainerNode toDOMSwitchInput(SwitchInput from) {
        return this.testContext.getCodec().currentSerializer().toNormalizedNodeRpcData((DataContainer)from);
    }

    private static final class SwitchImpl
    implements Switch {
        private final Multimap<String, SwitchInput> receivedSwitch = HashMultimap.create();
        private ListenableFuture<RpcResult<SwitchOutput>> switchResult;

        private SwitchImpl() {
        }

        SwitchImpl setSwitchResult(ListenableFuture<RpcResult<SwitchOutput>> switchOutput) {
            this.switchResult = switchOutput;
            return this;
        }

        Multimap<String, SwitchInput> getReceivedSwitch() {
            return this.receivedSwitch;
        }

        SwitchImpl registerTo(RpcProviderService registry) {
            Registration registration = registry.registerRpcImplementation((Rpc)this);
            Assert.assertNotNull((Object)registration);
            return this;
        }

        public ListenableFuture<RpcResult<SwitchOutput>> invoke(SwitchInput switchInput) {
            this.receivedSwitch.put((Object)switchInput.getFoo(), (Object)switchInput);
            return this.switchResult;
        }
    }
}

