/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.RpcAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingBrokerTestFactory;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingTestContext;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.RockTheHouse;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.RockTheHouseInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.RockTheHouseInputBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;

@ExtendWith(value={MockitoExtension.class})
class Mdsal739Test {
    private final ListeningExecutorService executorService = MoreExecutors.newDirectExecutorService();
    @Mock
    private DOMRpcService rpcService;
    @Captor
    private ArgumentCaptor<ContainerNode> captor;
    private AdapterContext adapterContext;

    Mdsal739Test() {
    }

    @BeforeEach
    void before() {
        BindingBrokerTestFactory bindingBrokerTestFactory = new BindingBrokerTestFactory();
        bindingBrokerTestFactory.setExecutor((ExecutorService)this.executorService);
        BindingTestContext bindingTestContext = bindingBrokerTestFactory.getTestContext();
        bindingTestContext.start();
        this.adapterContext = bindingTestContext.getCodec();
    }

    @AfterEach
    void after() {
        this.executorService.shutdownNow();
    }

    @Test
    void testRpcInputName() {
        ((DOMRpcService)Mockito.doReturn((Object)Futures.immediateFailedFuture((Throwable)new Throwable())).when((Object)this.rpcService)).invokeRpc((QName)ArgumentMatchers.any(), (ContainerNode)this.captor.capture());
        RockTheHouse adapter = (RockTheHouse)new RpcAdapter(this.adapterContext, this.rpcService, RockTheHouse.class).facade();
        ListenableFuture result = adapter.invoke(new RockTheHouseInputBuilder().setZipCode("12345").build());
        Assertions.assertThrows(ExecutionException.class, () -> Futures.getDone((Future)result));
        ContainerNode input = (ContainerNode)this.captor.getValue();
        Assertions.assertSame((Object)YangInstanceIdentifier.NodeIdentifier.create((QName)RockTheHouseInput.QNAME), (Object)input.name());
        Collection body = input.body();
        Assertions.assertEquals((int)1, (int)body.size());
        Assertions.assertEquals((Object)ImmutableNodes.leafNode((QName)QName.create((QName)RockTheHouseInput.QNAME, (String)"zip-code"), (Object)"12345"), body.iterator().next());
    }
}

