/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeLeafOnlyUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeLeafOnlyUsesAugmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;

public class WriteTransactionTest
extends AbstractDataBrokerTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    private static final TopLevelListKey TOP_LIST_KEY = new TopLevelListKey("foo");
    private static final InstanceIdentifier<TopLevelList> NODE_PATH = TOP_PATH.child(TopLevelList.class, (Key)TOP_LIST_KEY);
    private static final InstanceIdentifier<TreeLeafOnlyUsesAugment> NODE_AUGMENT_PATH = NODE_PATH.augmentation(TreeLeafOnlyUsesAugment.class);
    private static final TopLevelList NODE = new TopLevelListBuilder().withKey(TOP_LIST_KEY).build();
    private static final TreeLeafOnlyUsesAugment NODE_AUGMENT = new TreeLeafOnlyUsesAugmentBuilder().setLeafFromGrouping("foo").build();

    @Test
    public void test() throws Exception {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        writeTx.put(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE);
        writeTx.commit().get();
    }

    @Test
    public void testPutCreateParentsSuccess() throws Exception {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructurePut(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE);
        writeTx.commit().get();
        this.assertTop(new TopBuilder().setTopLevelList(BindingMap.of((KeyAware)NODE)).build());
    }

    @Test
    public void testPutCreateAugmentationParentsSuccess() throws Exception {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructurePut(LogicalDatastoreType.OPERATIONAL, NODE_AUGMENT_PATH, (DataObject)NODE_AUGMENT);
        writeTx.commit().get();
        this.assertTop(new TopBuilder().setTopLevelList(BindingMap.of((KeyAware)new TopLevelListBuilder().withKey(TOP_LIST_KEY).addAugmentation((Augmentation)NODE_AUGMENT).build())).build());
    }

    @Test
    public void testPutCreateParentsSuperfluous() throws Exception {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructurePut(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        writeTx.commit().get();
    }

    @Test
    public void testMergeCreateParentsSuccess() throws Exception {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructureMerge(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE);
        writeTx.commit().get();
        this.assertTop(new TopBuilder().setTopLevelList(BindingMap.of((KeyAware)NODE)).build());
    }

    @Test
    public void testMergeCreateAugmentationParentsSuccess() throws Exception {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructureMerge(LogicalDatastoreType.OPERATIONAL, NODE_AUGMENT_PATH, (DataObject)NODE_AUGMENT);
        writeTx.commit().get();
        this.assertTop(new TopBuilder().setTopLevelList(BindingMap.of((KeyAware)new TopLevelListBuilder().withKey(TOP_LIST_KEY).addAugmentation((Augmentation)NODE_AUGMENT).build())).build());
    }

    @Test
    public void testMergeCreateParentsSuperfluous() throws Exception {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.mergeParentStructurePut(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        writeTx.commit().get();
    }

    private void assertTop(Top expected) throws Exception {
        try (ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();){
            Assert.assertEquals(Optional.of(expected), (Object)readTx.read(LogicalDatastoreType.OPERATIONAL, TOP_PATH).get());
        }
    }
}

