/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.query.QueryExecutor;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryFactory;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQueryFactory;
import org.opendaylight.mdsal.binding.dom.adapter.query.SimpleQueryExecutor;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeFactory;
import org.opendaylight.mdsal.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.Foo;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.FooBuilder;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.first.grp.System;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.first.grp.SystemBuilder;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.first.grp.SystemKey;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.second.grp.Alarms;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.second.grp.AlarmsBuilder;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.third.grp.AffectedUsers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.top.level.list.NestedList;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilderTest {
    private static final Logger LOG = LoggerFactory.getLogger(QueryBuilderTest.class);
    private static BindingCodecTree CODEC;
    private final QueryFactory factory = new DefaultQueryFactory(CODEC);
    private QueryExecutor executor;

    @BeforeClass
    public static final void beforeClass() {
        CODEC = ServiceLoader.load(BindingCodecTreeFactory.class).findFirst().orElseThrow().create(BindingRuntimeHelpers.createRuntimeContext());
    }

    @AfterClass
    public static final void afterClass() {
        CODEC = null;
    }

    @Before
    public void before() {
        this.executor = SimpleQueryExecutor.builder((BindingCodecTree)CODEC).add((ChildOf)new FooBuilder().setSystem(BindingMap.of((KeyAware)new SystemBuilder().setName("first").setAlarms(BindingMap.of((KeyAware)new AlarmsBuilder().setId(Uint64.ZERO).setCritical(Empty.value()).setAffectedUsers(BindingMap.of((KeyAware[])new AffectedUsers[0])).build(), (KeyAware)new AlarmsBuilder().setId(Uint64.ONE).setAffectedUsers(BindingMap.of((KeyAware[])new AffectedUsers[0])).build(), (KeyAware)new AlarmsBuilder().setId(Uint64.TWO).setCritical(Empty.value()).setAffectedUsers(BindingMap.of((KeyAware[])new AffectedUsers[0])).build())).build(), (KeyAware)new SystemBuilder().setName("second").setAlarms(BindingMap.of((KeyAware)new AlarmsBuilder().setId(Uint64.ZERO).setCritical(Empty.value()).setAffectedUsers(BindingMap.of((KeyAware[])new AffectedUsers[0])).build())).build())).build()).build();
    }

    @Test
    public void bar() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Top.class)).extractChild(TopLevelList.class).matching().childObject(NestedList.class).leaf(NestedList::getName).contains("foo").and().leaf(TopLevelList::getName).valueEquals((Object)"bar").build();
        LOG.info("Query built in {}", (Object)sw);
        Assert.assertEquals((long)0L, (long)this.execute(query).getItems().size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFindCriticalAlarms() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class).extractChild(Alarms.class).matching().leaf(Alarms::getCritical).nonNull().build();
        LOG.info("Query built in {}", (Object)sw);
        @NonNull List items = this.execute(query).getItems();
        Assert.assertEquals((long)3L, (long)items.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFindNonCriticalAlarms() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class).extractChild(Alarms.class).matching().leaf(Alarms::getCritical).isNull().build();
        LOG.info("Query built in {}", (Object)sw);
        @NonNull List items = this.execute(query).getItems();
        Assert.assertEquals((long)1L, (long)items.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFindZeroAlarms() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class).extractChild(Alarms.class).matching().leaf(Alarms::getId).valueEquals((Object)Uint64.ZERO).build();
        LOG.info("Query built in {}", (Object)sw);
        @NonNull List items = this.execute(query).getItems();
        Assert.assertEquals((long)2L, (long)items.size());
        List verifiedResult = items.stream().map(QueryResult.Item::object).filter(object -> object.getId().equals(Uint64.ZERO)).collect(Collectors.toList());
        Assert.assertNotNull(verifiedResult);
        Assert.assertEquals((long)2L, (long)verifiedResult.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFindSystemFirstAlarmOne() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class, (Key)new SystemKey("first")).extractChild(Alarms.class).matching().leaf(Alarms::getId).valueEquals((Object)Uint64.ZERO).build();
        LOG.info("Query built in {}", (Object)sw);
        @NonNull List items = this.execute(query).getItems();
        Assert.assertEquals((long)1L, (long)items.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFindGreaterThanAlarms() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class).extractChild(Alarms.class).matching().leaf(Alarms::getId).greaterThan((Comparable)Uint64.ONE).build();
        LOG.info("Query built in {}", (Object)sw);
        @NonNull List items = this.execute(query).getItems();
        Assert.assertEquals((long)1L, (long)items.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFindGreaterThanOrEqualsAlarms() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class).extractChild(Alarms.class).matching().leaf(Alarms::getId).greaterThanOrEqual((Comparable)Uint64.ONE).build();
        LOG.info("Query built in {}", (Object)sw);
        @NonNull List items = this.execute(query).getItems();
        Assert.assertEquals((long)2L, (long)items.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFindLessThanAlarms() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class).extractChild(Alarms.class).matching().leaf(Alarms::getId).lessThan((Comparable)Uint64.ONE).build();
        LOG.info("Query built in {}", (Object)sw);
        @NonNull List items = this.execute(query).getItems();
        Assert.assertEquals((long)2L, (long)items.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFindLessThanOrEqualsAlarms() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class).extractChild(Alarms.class).matching().leaf(Alarms::getId).lessThanOrEqual((Comparable)Uint64.ONE).build();
        LOG.info("Query built in {}", (Object)sw);
        @NonNull List items = this.execute(query).getItems();
        Assert.assertEquals((long)3L, (long)items.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFindSystemFirstWithAlarmOne() {
        Stopwatch sw = Stopwatch.createStarted();
        QueryExpression query = (QueryExpression)this.factory.querySubtree(InstanceIdentifier.create(Foo.class)).extractChild(System.class, (Key)new SystemKey("first")).matching().childObject(Alarms.class).leaf(Alarms::getId).valueEquals((Object)Uint64.ZERO).build();
        LOG.info("Query built in {}", (Object)sw);
        @NonNull List items = this.execute(query).getItems();
        Assert.assertEquals((long)1L, (long)items.size());
    }

    private <T extends DataObject> QueryResult<T> execute(QueryExpression<T> query) {
        Stopwatch sw = Stopwatch.createStarted();
        QueryResult result = this.executor.executeQuery(query);
        LOG.info("Query executed in {}", (Object)sw);
        return result;
    }
}

