/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataBrokerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationPublishServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.MockSchemaService;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.broker.DOMNotificationRouter;
import org.opendaylight.mdsal.dom.broker.SerializedDOMDataBroker;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStore;

public abstract class AbstractDataBrokerTestCustomizer {
    private final DOMNotificationRouter domNotificationRouter = new DOMNotificationRouter(16);
    private final MockSchemaService schemaService = new MockSchemaService();
    private DOMDataBroker domDataBroker;
    private ImmutableMap<LogicalDatastoreType, DOMStore> datastores;

    public ImmutableMap<LogicalDatastoreType, DOMStore> createDatastores() {
        return ImmutableMap.builder().put((Object)LogicalDatastoreType.OPERATIONAL, (Object)this.createOperationalDatastore()).put((Object)LogicalDatastoreType.CONFIGURATION, (Object)this.createConfigurationDatastore()).build();
    }

    public DOMStore createConfigurationDatastore() {
        InMemoryDOMDataStore store = new InMemoryDOMDataStore("CFG", (ExecutorService)this.getDataTreeChangeListenerExecutor());
        this.schemaService.registerSchemaContextListener(arg_0 -> ((InMemoryDOMDataStore)store).onModelContextUpdated(arg_0));
        return store;
    }

    public DOMStore createOperationalDatastore() {
        InMemoryDOMDataStore store = new InMemoryDOMDataStore("OPER", (ExecutorService)this.getDataTreeChangeListenerExecutor());
        this.schemaService.registerSchemaContextListener(arg_0 -> ((InMemoryDOMDataStore)store).onModelContextUpdated(arg_0));
        return store;
    }

    public DOMDataBroker createDOMDataBroker() {
        return new SerializedDOMDataBroker(this.getDatastores(), (Executor)this.getCommitCoordinatorExecutor());
    }

    public NotificationService createNotificationService() {
        return new BindingDOMNotificationServiceAdapter((AdapterContext)this.schemaService, this.domNotificationRouter.notificationService());
    }

    public NotificationPublishService createNotificationPublishService() {
        return new BindingDOMNotificationPublishServiceAdapter((AdapterContext)this.schemaService, this.domNotificationRouter.notificationPublishService());
    }

    public abstract ListeningExecutorService getCommitCoordinatorExecutor();

    public ListeningExecutorService getDataTreeChangeListenerExecutor() {
        return MoreExecutors.newDirectExecutorService();
    }

    public DataBroker createDataBroker() {
        return new BindingDOMDataBrokerAdapter((AdapterContext)this.schemaService, this.getDOMDataBroker());
    }

    public AdapterContext getAdapterContext() {
        return this.schemaService;
    }

    public DOMSchemaService getSchemaService() {
        return this.schemaService;
    }

    public DOMDataBroker getDOMDataBroker() {
        if (this.domDataBroker == null) {
            this.domDataBroker = this.createDOMDataBroker();
        }
        return this.domDataBroker;
    }

    private synchronized ImmutableMap<LogicalDatastoreType, DOMStore> getDatastores() {
        if (this.datastores == null) {
            this.datastores = this.createDatastores();
        }
        return this.datastores;
    }

    public void updateSchema(BindingRuntimeContext ctx) {
        this.schemaService.changeSchema(ctx);
    }

    public DOMNotificationRouter getDomNotificationRouter() {
        return this.domNotificationRouter;
    }
}

