/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.test;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.Assert;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class AbstractDataTreeChangeListenerTest
extends AbstractConcurrentDataBrokerTest {
    protected AbstractDataTreeChangeListenerTest() {
        super(true);
    }

    protected final <T extends DataObject> @NonNull ModificationCollector<T> createCollector(LogicalDatastoreType store, InstanceIdentifier<T> path) {
        TestListener listener = new TestListener();
        Registration reg = this.getDataBroker().registerDataTreeChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)store, path), listener);
        listener.awaitSync();
        return new ModificationCollector(listener, reg);
    }

    public static <T extends DataObject> @NonNull Matcher<T> match(DataObjectModification.ModificationType type, InstanceIdentifier<T> path, DataMatcher<T> checkDataBefore, DataMatcher<T> checkDataAfter) {
        return modification -> type == modification.getRootNode().modificationType() && path.equals((Object)modification.getRootPath().path()) && checkDataBefore.apply(modification.getRootNode().dataBefore()) && checkDataAfter.apply(modification.getRootNode().dataAfter());
    }

    public static <T extends DataObject> @NonNull Matcher<T> match(DataObjectModification.ModificationType type, InstanceIdentifier<T> path, T expDataBefore, T expDataAfter) {
        return AbstractDataTreeChangeListenerTest.match(type, path, dataBefore -> Objects.equals(expDataBefore, dataBefore), dataAfter -> Objects.equals(expDataAfter, dataAfter));
    }

    public static <T extends DataObject> @NonNull Matcher<T> added(InstanceIdentifier<T> path, T data) {
        return AbstractDataTreeChangeListenerTest.match(DataObjectModification.ModificationType.WRITE, path, null, data);
    }

    public static <T extends DataObject> @NonNull Matcher<T> replaced(InstanceIdentifier<T> path, T dataBefore, T dataAfter) {
        return AbstractDataTreeChangeListenerTest.match(DataObjectModification.ModificationType.WRITE, path, dataBefore, dataAfter);
    }

    public static <T extends DataObject> @NonNull Matcher<T> deleted(InstanceIdentifier<T> path, T dataBefore) {
        return AbstractDataTreeChangeListenerTest.match(DataObjectModification.ModificationType.DELETE, path, dataBefore, null);
    }

    public static <T extends DataObject> @NonNull Matcher<T> subtreeModified(InstanceIdentifier<T> path, T dataBefore, T dataAfter) {
        return AbstractDataTreeChangeListenerTest.match(DataObjectModification.ModificationType.SUBTREE_MODIFIED, path, dataBefore, dataAfter);
    }

    private static final class TestListener<T extends DataObject>
    implements DataTreeChangeListener<T> {
        private final Deque<DataTreeModification<T>> accumulatedChanges = new ArrayDeque<DataTreeModification<T>>();
        private boolean synced;

        private TestListener() {
        }

        public synchronized void onDataTreeChanged(List<DataTreeModification<T>> changes) {
            this.accumulatedChanges.addAll(changes);
            this.synced = true;
        }

        public synchronized void onInitialData() {
            this.synced = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitSync() {
            Stopwatch sw = Stopwatch.createStarted();
            do {
                TestListener testListener = this;
                synchronized (testListener) {
                    if (this.synced) {
                        return;
                    }
                }
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            } while (sw.elapsed(TimeUnit.SECONDS) < 5L);
            throw new AssertionError((Object)"Failed to achieve initial sync");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Deque<DataTreeModification<T>> awaitChanges(int expectedCount) {
            ArrayDeque<DataTreeModification<T>> ret = new ArrayDeque<DataTreeModification<T>>(expectedCount);
            Stopwatch sw = Stopwatch.createStarted();
            int remaining = expectedCount;
            do {
                TestListener testListener = this;
                synchronized (testListener) {
                    DataTreeModification<T> change;
                    while (remaining != 0 && (change = this.accumulatedChanges.poll()) != null) {
                        --remaining;
                        ret.add(change);
                    }
                }
                if (remaining == 0) {
                    return ret;
                }
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            } while (sw.elapsed(TimeUnit.SECONDS) < 5L);
            throw new AssertionError((Object)"Expected %s changes, received only %s".formatted(expectedCount, ret.size()));
        }

        synchronized int changeCount() {
            return this.accumulatedChanges.size();
        }
    }

    protected static final class ModificationCollector<T extends DataObject>
    implements AutoCloseable {
        private final TestListener<T> listener;
        private final Registration reg;

        private ModificationCollector(TestListener<T> listener, Registration reg) {
            this.listener = Objects.requireNonNull(listener);
            this.reg = Objects.requireNonNull(reg);
        }

        @SafeVarargs
        public final void verifyModifications(Matcher<T> ... inOrder) {
            ArrayDeque<Matcher<T>> matchers = new ArrayDeque<Matcher<T>>(Arrays.asList(inOrder));
            Deque<DataTreeModification<T>> changes = this.listener.awaitChanges(matchers.size());
            while (!changes.isEmpty()) {
                DataTreeModification<T> mod = changes.pop();
                Matcher<T> matcher = matchers.pop();
                if (matcher.apply(mod)) continue;
                DataObjectModification rootNode = mod.getRootNode();
                Assert.fail((String)"Received unexpected notification: type: %s, path: %s, before: %s, after: %s".formatted(rootNode.modificationType(), mod.getRootPath().path(), rootNode.dataBefore(), rootNode.dataAfter()));
                return;
            }
            int count = this.listener.changeCount();
            if (count != 0) {
                throw new AssertionError((Object)"Expected no more changes, %s remain".formatted(count));
            }
        }

        @Override
        public void close() {
            this.reg.close();
        }
    }

    @FunctionalInterface
    protected static interface DataMatcher<T extends DataObject> {
        public boolean apply(T var1);
    }

    @FunctionalInterface
    protected static interface Matcher<T extends DataObject> {
        public boolean apply(DataTreeModification<T> var1);
    }
}

