/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.test;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.Before;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public abstract class AbstractSchemaAwareTest {
    private static final LoadingCache<Set<YangModuleInfo>, BindingRuntimeContext> RUNTIME_CONTEXT_CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Set<YangModuleInfo>, BindingRuntimeContext>(){

        public BindingRuntimeContext load(Set<YangModuleInfo> key) {
            return BindingRuntimeHelpers.createRuntimeContext(key);
        }
    });
    private static final LoadingCache<ClassLoader, ImmutableSet<YangModuleInfo>> MODULE_INFO_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<ClassLoader, ImmutableSet<YangModuleInfo>>(){

        public ImmutableSet<YangModuleInfo> load(ClassLoader key) {
            return BindingRuntimeHelpers.loadModuleInfos((ClassLoader)key);
        }
    });

    @Before
    public final void setup() throws Exception {
        this.setupWithRuntimeContext(this.getRuntimeContext());
    }

    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return AbstractSchemaAwareTest.cacheModuleInfos(Thread.currentThread().getContextClassLoader());
    }

    protected BindingRuntimeContext getRuntimeContext() throws Exception {
        return (BindingRuntimeContext)RUNTIME_CONTEXT_CACHE.getUnchecked(this.getModuleInfos());
    }

    protected EffectiveModelContext modelContext() throws Exception {
        return this.getRuntimeContext().modelContext();
    }

    protected void setupWithRuntimeContext(BindingRuntimeContext runtimeContext) {
        this.setupWithSchema(runtimeContext.modelContext());
    }

    protected void setupWithSchema(EffectiveModelContext context) {
    }

    protected static final @NonNull ImmutableSet<YangModuleInfo> cacheModuleInfos(ClassLoader loader) {
        return (ImmutableSet)MODULE_INFO_CACHE.getUnchecked((Object)loader);
    }
}

