/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.test.util;

import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecFactory;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.ObjectRegistry;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public final class MockSchemaService
implements DOMSchemaService,
AdapterContext {
    private static final LoadingCache<BindingRuntimeContext, BindingDOMCodecServices> CODEC_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<BindingRuntimeContext, BindingDOMCodecServices>(){

        public BindingDOMCodecServices load(BindingRuntimeContext key) {
            return ServiceLoader.load(BindingDOMCodecFactory.class).findFirst().orElseThrow().createBindingDOMCodec(key);
        }
    });
    private EffectiveModelContext modelContext;
    private CurrentAdapterSerializer serializer;
    final ObjectRegistry<Consumer<EffectiveModelContext>> listeners = ObjectRegistry.createConcurrent((String)"mock schema");

    public synchronized EffectiveModelContext getGlobalContext() {
        return this.modelContext;
    }

    public Registration registerSchemaContextListener(Consumer<EffectiveModelContext> listener) {
        return this.listeners.register(listener);
    }

    public synchronized void changeSchema(BindingRuntimeContext newContext) {
        this.serializer = new CurrentAdapterSerializer((BindingDOMCodecServices)CODEC_CACHE.getUnchecked((Object)newContext));
        this.modelContext = newContext.modelContext();
        this.listeners.streamObjects().forEach(listener -> listener.accept(this.modelContext));
    }

    public synchronized CurrentAdapterSerializer currentSerializer() {
        return (CurrentAdapterSerializer)Verify.verifyNotNull((Object)this.serializer);
    }
}

