/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.data.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

final class BindingDOMDataListenerAdapter<T extends DataObject>
implements DOMDataTreeChangeListener {
    private final AdapterContext adapterContext;
    private final DataListener<T> listener;

    BindingDOMDataListenerAdapter(AdapterContext adapterContext, DataListener<T> listener) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.listener = Objects.requireNonNull(listener);
    }

    public void onDataTreeChanged(List<DataTreeCandidate> changes) {
        DataTreeCandidate last = changes.get(changes.size() - 1);
        NormalizedNode after = last.getRootNode().dataAfter();
        this.listener.dataChangedTo(after == null ? null : (DataObject)this.deserialize(last.getRootPath(), after));
    }

    public void onInitialData() {
        this.listener.dataChangedTo(null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("listener", this.listener).toString();
    }

    private T deserialize(YangInstanceIdentifier path, @NonNull NormalizedNode data) {
        CommonDataObjectCodecTreeNode codec;
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        CommonDataObjectCodecTreeNode commonDataObjectCodecTreeNode = codec = serializer.getSubtreeCodec(serializer.coerceInstanceIdentifier(path));
        Objects.requireNonNull(commonDataObjectCodecTreeNode);
        CommonDataObjectCodecTreeNode commonDataObjectCodecTreeNode2 = commonDataObjectCodecTreeNode;
        int n = 0;
        return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BindingDataObjectCodecTreeNode.class, BindingAugmentationCodecTreeNode.class}, (Object)commonDataObjectCodecTreeNode2, n)) {
            case 0 -> {
                BindingDataObjectCodecTreeNode dataObject = (BindingDataObjectCodecTreeNode)commonDataObjectCodecTreeNode2;
                yield (DataObject)dataObject.deserialize(data);
            }
            case 1 -> {
                BindingAugmentationCodecTreeNode augmentation = (BindingAugmentationCodecTreeNode)commonDataObjectCodecTreeNode2;
                yield augmentation.filterFrom(data);
            }
            default -> throw new IllegalStateException("Unhandled codec " + String.valueOf(codec));
        });
    }
}

