/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.RpcService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingLoadingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.RpcAdapter;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.binding.reflect.BindingReflections;

@VisibleForTesting
public final class BindingDOMRpcServiceAdapter
extends AbstractBindingLoadingAdapter<DOMRpcService, Class<?>, RpcAdapter>
implements RpcService {
    static final BindingDOMAdapterBuilder.Factory<RpcService> BUILDER_FACTORY = Builder::new;

    public BindingDOMRpcServiceAdapter(AdapterContext adapterContext, DOMRpcService domService) {
        super(adapterContext, domService);
    }

    public <T extends Rpc<?, ?>> T getRpc(Class<T> rpcInterface) {
        return (T)((Rpc)rpcInterface.cast(((RpcAdapter)this.getAdapter(Objects.requireNonNull(rpcInterface))).facade()));
    }

    @Override
    RpcAdapter loadAdapter(Class<?> key) {
        Preconditions.checkArgument((boolean)BindingReflections.isBindingClass(key));
        Preconditions.checkArgument((boolean)key.isInterface(), (Object)"Supplied RPC service type must be interface.");
        if (Rpc.class.isAssignableFrom(key)) {
            return new RpcAdapter(this.adapterContext(), (DOMRpcService)this.getDelegate(), key.asSubclass(Rpc.class));
        }
        throw new IllegalStateException("Unhandled key " + String.valueOf(key));
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<RpcService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        public Set<? extends Class<? extends DOMService<?, ?>>> getRequiredDelegates() {
            return ImmutableSet.of(DOMRpcService.class);
        }

        @Override
        protected RpcService createInstance(ClassToInstanceMap<DOMService<?, ?>> delegates) {
            return new BindingDOMRpcServiceAdapter(this.adapterContext(), (DOMRpcService)delegates.getInstance(DOMRpcService.class));
        }
    }
}

