/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.util.concurrent.FluentFuture;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractForwardedTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.data.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingCodecTree;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.binding.data.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

class BindingDOMWriteTransactionAdapter<T extends DOMDataTreeWriteTransaction>
extends AbstractForwardedTransaction<T>
implements WriteTransaction {
    BindingDOMWriteTransactionAdapter(AdapterContext adapterContext, T delegateTx) {
        super(adapterContext, delegateTx);
    }

    public final <U extends DataObject> void put(LogicalDatastoreType store, DataObjectIdentifier<U> path, U data) {
        this.put(store, this.toNormalized("put", path, data));
    }

    private void put(LogicalDatastoreType store, BindingNormalizedNodeSerializer.NormalizedResult normalized) {
        DOMDataTreeWriteTransaction delegate = (DOMDataTreeWriteTransaction)this.getDelegate();
        YangInstanceIdentifier domPath = normalized.path();
        BindingNormalizedNodeSerializer.NormalizedResult normalizedResult = normalized;
        Objects.requireNonNull(normalizedResult);
        BindingNormalizedNodeSerializer.NormalizedResult normalizedResult2 = normalizedResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BindingNormalizedNodeSerializer.AugmentationResult.class, BindingNormalizedNodeSerializer.NodeResult.class}, (Object)normalizedResult2, n)) {
            case 0: {
                BindingNormalizedNodeSerializer.AugmentationResult augment = (BindingNormalizedNodeSerializer.AugmentationResult)normalizedResult2;
                HashSet<YangInstanceIdentifier.NodeIdentifier> putIds = new HashSet<YangInstanceIdentifier.NodeIdentifier>();
                for (DataContainerChild child : augment.children()) {
                    YangInstanceIdentifier.NodeIdentifier childId = child.name();
                    delegate.put(store, domPath.node((YangInstanceIdentifier.PathArgument)childId), (NormalizedNode)child);
                    putIds.add(childId);
                }
                for (YangInstanceIdentifier.NodeIdentifier childId : augment.possibleChildren()) {
                    if (putIds.contains(childId)) continue;
                    delegate.delete(store, domPath.node((YangInstanceIdentifier.PathArgument)childId));
                }
                break;
            }
            case 1: {
                BindingNormalizedNodeSerializer.NodeResult node = (BindingNormalizedNodeSerializer.NodeResult)normalizedResult2;
                delegate.put(store, domPath, node.node());
                break;
            }
            default: {
                throw new VerifyException("Unhandled result " + String.valueOf(normalized));
            }
        }
    }

    @Deprecated
    public final <U extends DataObject> void mergeParentStructurePut(LogicalDatastoreType store, DataObjectIdentifier<U> path, U data) {
        CurrentAdapterSerializer serializer = this.adapterContext().currentSerializer();
        BindingNormalizedNodeSerializer.NormalizedResult normalized = BindingDOMWriteTransactionAdapter.toNormalized(serializer, "put", path, data);
        this.ensureParentsByMerge(serializer, store, normalized);
        this.put(store, normalized);
    }

    public final <D extends DataObject> void merge(LogicalDatastoreType store, DataObjectIdentifier<D> path, D data) {
        this.merge(store, this.toNormalized("merge", path, data));
    }

    private void merge(LogicalDatastoreType store, BindingNormalizedNodeSerializer.NormalizedResult normalized) {
        DOMDataTreeWriteTransaction delegate = (DOMDataTreeWriteTransaction)this.getDelegate();
        YangInstanceIdentifier domPath = normalized.path();
        BindingNormalizedNodeSerializer.NormalizedResult normalizedResult = normalized;
        Objects.requireNonNull(normalizedResult);
        BindingNormalizedNodeSerializer.NormalizedResult normalizedResult2 = normalizedResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BindingNormalizedNodeSerializer.AugmentationResult.class, BindingNormalizedNodeSerializer.NodeResult.class}, (Object)normalizedResult2, n)) {
            case 0: {
                BindingNormalizedNodeSerializer.AugmentationResult augment = (BindingNormalizedNodeSerializer.AugmentationResult)normalizedResult2;
                for (DataContainerChild child : augment.children()) {
                    delegate.merge(store, domPath.node((YangInstanceIdentifier.PathArgument)child.name()), (NormalizedNode)child);
                }
                break;
            }
            case 1: {
                BindingNormalizedNodeSerializer.NodeResult node = (BindingNormalizedNodeSerializer.NodeResult)normalizedResult2;
                delegate.merge(store, domPath, node.node());
                break;
            }
            default: {
                throw new VerifyException("Unhandled result " + String.valueOf(normalized));
            }
        }
    }

    @Deprecated
    public final <U extends DataObject> void mergeParentStructureMerge(LogicalDatastoreType store, DataObjectIdentifier<U> path, U data) {
        CurrentAdapterSerializer serializer = this.adapterContext().currentSerializer();
        BindingNormalizedNodeSerializer.NormalizedResult normalized = BindingDOMWriteTransactionAdapter.toNormalized(serializer, "merge", path, data);
        this.ensureParentsByMerge(serializer, store, normalized);
        this.merge(store, normalized);
    }

    public final void delete(LogicalDatastoreType store, DataObjectIdentifier<?> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Cannot delete wildcarded path %s", path);
        CurrentAdapterSerializer serializer = this.adapterContext().currentSerializer();
        BindingCodecTree.CodecWithPath codecWithPath = serializer.getSubtreeCodecWithPath((DataObjectReference)path);
        YangInstanceIdentifier domPath = codecWithPath.path();
        DOMDataTreeWriteTransaction delegate = (DOMDataTreeWriteTransaction)this.getDelegate();
        CommonDataObjectCodecTreeNode commonDataObjectCodecTreeNode = codecWithPath.codec();
        if (commonDataObjectCodecTreeNode instanceof BindingAugmentationCodecTreeNode) {
            BindingAugmentationCodecTreeNode augmentCodec = (BindingAugmentationCodecTreeNode)commonDataObjectCodecTreeNode;
            for (YangInstanceIdentifier.NodeIdentifier childPath : augmentCodec.childPathArguments()) {
                delegate.delete(store, domPath.node((YangInstanceIdentifier.PathArgument)childPath));
            }
        } else {
            delegate.delete(store, domPath);
        }
    }

    public FluentFuture<? extends CommitInfo> commit() {
        return ((DOMDataTreeWriteTransaction)this.getDelegate()).commit();
    }

    public final boolean cancel() {
        return ((DOMDataTreeWriteTransaction)this.getDelegate()).cancel();
    }

    public FluentFuture<?> completionFuture() {
        return ((DOMDataTreeWriteTransaction)this.getDelegate()).completionFuture();
    }

    private void ensureParentsByMerge(CurrentAdapterSerializer serializer, LogicalDatastoreType store, BindingNormalizedNodeSerializer.NormalizedResult normalized) {
        YangInstanceIdentifier parentPath;
        YangInstanceIdentifier path = normalized.path();
        YangInstanceIdentifier yangInstanceIdentifier = parentPath = normalized instanceof BindingNormalizedNodeSerializer.AugmentationResult ? path : path.getParent();
        if (parentPath != null && !parentPath.isEmpty()) {
            NormalizedNode parentNode = ImmutableNodes.fromInstanceId((EffectiveModelContext)serializer.getRuntimeContext().modelContext(), (YangInstanceIdentifier)parentPath);
            ((DOMDataTreeWriteTransaction)this.getDelegate()).merge(store, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)parentNode.name()), parentNode);
        }
    }

    private <U extends DataObject> // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull BindingNormalizedNodeSerializer.NormalizedResult toNormalized(String operation, DataObjectIdentifier<U> path, U data) {
        return BindingDOMWriteTransactionAdapter.toNormalized(this.adapterContext().currentSerializer(), operation, path, data);
    }

    private static <U extends DataObject> // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull BindingNormalizedNodeSerializer.NormalizedResult toNormalized(CurrentAdapterSerializer serializer, String operation, DataObjectIdentifier<U> path, U data) {
        return serializer.toNormalizedNode((DataObjectReference)path, data);
    }
}

