/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Verify;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.yangtools.binding.BaseNotification;
import org.opendaylight.yangtools.binding.EventInstantAware;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

abstract class AbstractLazySerializedEvent<T extends BaseNotification>
implements DOMNotification,
DOMEvent {
    private final @NonNull BindingNormalizedNodeSerializer codec;
    private final @NonNull T data;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute type;
    private final @NonNull Instant eventInstant;
    private volatile ContainerNode domBody;

    AbstractLazySerializedEvent(BindingNormalizedNodeSerializer codec, T data, SchemaNodeIdentifier.Absolute type) {
        Instant instant;
        this.codec = Objects.requireNonNull(codec);
        this.data = (BaseNotification)Objects.requireNonNull(data);
        this.type = Objects.requireNonNull(type);
        if (data instanceof EventInstantAware) {
            EventInstantAware aware = (EventInstantAware)data;
            instant = aware.eventInstant();
        } else {
            instant = Instant.now();
        }
        this.eventInstant = instant;
    }

    public final SchemaNodeIdentifier.Absolute getType() {
        return this.type;
    }

    public final ContainerNode getBody() {
        ContainerNode local = this.domBody;
        if (local == null) {
            this.domBody = local = (ContainerNode)Verify.verifyNotNull((Object)this.loadBody(this.codec));
        }
        return local;
    }

    abstract @NonNull ContainerNode loadBody(@NonNull BindingNormalizedNodeSerializer var1);

    public final Instant getEventInstant() {
        return this.eventInstant;
    }

    final @NonNull T getBindingData() {
        return this.data;
    }
}

