/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.ContextReferenceExtractor;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.RpcInvocationStrategy;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.ContentRoutedRpcContext;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.binding.RpcInput;
import org.opendaylight.yangtools.binding.runtime.api.RpcRuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;

final class RpcAdapter
implements InvocationHandler {
    private final @NonNull AdapterContext adapterContext;
    private final @NonNull DOMRpcService delegate;
    private final RpcInvocationStrategy strategy;
    private final @NonNull Rpc<?, ?> facade;
    private final String name;

    <T extends Rpc<?, ?>> RpcAdapter(AdapterContext adapterContext, DOMRpcService delegate, Class<T> type) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.delegate = Objects.requireNonNull(delegate);
        CurrentAdapterSerializer serializer = adapterContext.currentSerializer();
        RpcRuntimeType rpcType = serializer.getRuntimeContext().getRpcDefinition(type);
        if (rpcType == null) {
            throw new IllegalStateException("Failed to find runtime type for " + String.valueOf(type));
        }
        this.facade = (Rpc)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)this));
        this.name = type.getName();
        this.strategy = this.createStrategy(serializer, rpcType);
    }

    private @NonNull RpcInvocationStrategy createStrategy(CurrentAdapterSerializer serializer, RpcRuntimeType rpcType) {
        ContextReferenceExtractor extractor;
        RpcEffectiveStatement rpc = rpcType.statement();
        ContentRoutedRpcContext contentContext = ContentRoutedRpcContext.forRpc((RpcEffectiveStatement)rpc);
        if (contentContext != null && (extractor = serializer.findExtractor(rpcType.input())) != null) {
            return new RpcInvocationStrategy.ContentRouted(this, (QName)rpc.argument(), contentContext.leaf(), extractor);
        }
        return new RpcInvocationStrategy(this, (QName)rpc.argument());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "invoke": {
                if (method.getParameterCount() != 1) break;
                return this.strategy.invoke((RpcInput)Objects.requireNonNull(args[0]));
            }
            case "toString": {
                if (!method.getReturnType().equals(String.class) || method.getParameterCount() != 0) break;
                return this.name + "$Adapter{delegate=" + String.valueOf(this.delegate) + "}";
            }
            case "hashCode": {
                if (!method.getReturnType().equals(Integer.TYPE) || method.getParameterCount() != 0) break;
                return System.identityHashCode(proxy);
            }
            case "equals": {
                if (!method.getReturnType().equals(Boolean.TYPE) || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Object.class) break;
                return proxy == args[0];
            }
        }
        if (method.isDefault()) {
            return InvocationHandler.invokeDefault(proxy, method, args);
        }
        throw new UnsupportedOperationException("Method " + method.toString() + " is not supported");
    }

    @NonNull CurrentAdapterSerializer currentSerializer() {
        return this.adapterContext.currentSerializer();
    }

    @NonNull DOMRpcService delegate() {
        return this.delegate;
    }

    @NonNull Rpc<?, ?> facade() {
        return this.facade;
    }
}

