/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.query.DescendantQueryBuilder;
import org.opendaylight.mdsal.binding.api.query.MatchBuilderPath;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultMatchBuilderPath;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQueryFactory;
import org.opendaylight.mdsal.binding.dom.adapter.query.QueryBuilderState;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

final class DefaultDescendantQueryBuilder<R extends DataObject, T extends DataObject>
implements DescendantQueryBuilder<T> {
    private final InstanceIdentifier.Builder<T> childPath;
    private final QueryBuilderState builder;

    DefaultDescendantQueryBuilder(DefaultQueryFactory factory, InstanceIdentifier<T> rootPath) {
        this.builder = new QueryBuilderState(factory, rootPath);
        this.childPath = rootPath.builder();
    }

    public <N extends ChildOf<? super T>> DescendantQueryBuilder<N> extractChild(Class<N> childClass) {
        this.childPath.child(childClass);
        return this;
    }

    public <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> DescendantQueryBuilder<N> extractChild(Class<C> caseClass, Class<N> childClass) {
        this.childPath.child(caseClass, childClass);
        return this;
    }

    public <N extends EntryObject<N, K> & ChildOf<? super T>, K extends Key<N>> DescendantQueryBuilder<N> extractChild(Class<@NonNull N> listItem, K listKey) {
        this.childPath.child(listItem, listKey);
        return this;
    }

    public MatchBuilderPath<T, T> matching() {
        InstanceIdentifier selectPath = this.childPath.build();
        this.builder.setSelectPath(selectPath);
        return new DefaultMatchBuilderPath(this.builder, selectPath, this.childPath);
    }

    public QueryExpression<T> build() {
        this.builder.setSelectPath(this.childPath.build());
        return this.builder.buildQuery();
    }
}

