/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.osgi.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.primitives.UnsignedLong;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingLazyContainerNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeWriterFactory;
import org.opendaylight.mdsal.binding.dom.codec.osgi.OSGiBindingDOMCodecServices;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.binding.dom.codec.spi.ForwardingBindingDOMCodecServices;
import org.opendaylight.mdsal.binding.dom.codec.spi.LazyActionInputContainerNode;
import org.opendaylight.mdsal.binding.dom.codec.spi.LazyActionOutputContainerNode;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true, service={BindingDOMCodecServices.class, BindingNormalizedNodeWriterFactory.class, BindingNormalizedNodeSerializer.class, BindingCodecTree.class})
public final class GlobalBindingDOMCodecServices
extends ForwardingBindingDOMCodecServices {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBindingDOMCodecServices.class);
    private BindingDOMCodecServices delegate;
    private UnsignedLong generation;

    @Activate
    public GlobalBindingDOMCodecServices(@Reference(updated="update") OSGiBindingDOMCodecServices services) {
        this.updateDelegate(services);
        LOG.info("Global Binding/DOM Codec activated with generation {}", (Object)this.generation);
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
        LOG.info("Global Binding/DOM Codec deactivated");
    }

    void update(OSGiBindingDOMCodecServices services) {
        this.updateDelegate(services);
        LOG.info("Global Binding/DOM Codec updated to generation {}", (Object)this.generation);
    }

    private void updateDelegate(OSGiBindingDOMCodecServices services) {
        this.generation = services.getGeneration();
        this.delegate = (BindingDOMCodecServices)services.getService();
    }

    public BindingLazyContainerNode<RpcInput> toLazyNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, YangInstanceIdentifier.NodeIdentifier identifier, RpcInput input) {
        return new LazyActionInputContainerNode(identifier, input, (BindingNormalizedNodeSerializer)this, action);
    }

    public BindingLazyContainerNode<RpcOutput> toLazyNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, YangInstanceIdentifier.NodeIdentifier identifier, RpcOutput output) {
        return new LazyActionOutputContainerNode(identifier, output, (BindingNormalizedNodeSerializer)this, action);
    }

    protected BindingDOMCodecServices delegate() {
        return (BindingDOMCodecServices)Verify.verifyNotNull((Object)this.delegate);
    }
}

