/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractBindingNormalizedNodeCache;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectNormalizedNodeCache;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.TypeObjectNormalizedNodeCache;
import org.opendaylight.yangtools.yang.binding.BindingObject;

abstract class AbstractBindingNormalizedNodeCacheHolder {
    private final LoadingCache<CodecContext, AbstractBindingNormalizedNodeCache> caches = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CodecContext, AbstractBindingNormalizedNodeCache>(){

        public AbstractBindingNormalizedNodeCache load(CodecContext key) {
            if (key instanceof DataContainerCodecContext) {
                DataContainerCodecContext dataContainer = (DataContainerCodecContext)key;
                return new DataObjectNormalizedNodeCache(AbstractBindingNormalizedNodeCacheHolder.this, dataContainer);
            }
            if (key instanceof LeafNodeCodecContext.OfTypeObject) {
                LeafNodeCodecContext.OfTypeObject typeObject = (LeafNodeCodecContext.OfTypeObject)key;
                return new TypeObjectNormalizedNodeCache<LeafNodeCodecContext.OfTypeObject>(typeObject);
            }
            throw new IllegalStateException("Unhandled context " + key);
        }
    });
    private final ImmutableSet<Class<?>> cacheSpec;

    AbstractBindingNormalizedNodeCacheHolder(ImmutableSet<Class<?>> cacheSpec) {
        this.cacheSpec = Objects.requireNonNull(cacheSpec);
    }

    <T extends BindingObject, C extends CodecContext> AbstractBindingNormalizedNodeCache<T, C> getCachingSerializer(C childCtx) {
        return this.isCached(((BindingObjectCodecTreeNode)childCtx).getBindingClass()) ? (AbstractBindingNormalizedNodeCache)((Object)this.caches.getUnchecked(childCtx)) : null;
    }

    final boolean isCached(Class<?> type) {
        return this.cacheSpec.contains(type);
    }
}

