/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerAnalysis;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectStep;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractDataObjectCodecContext<D extends DataObject, T extends CompositeRuntimeType>
extends CommonDataObjectCodecContext<D, T> {
    private final ImmutableMap<Class<?>, DataContainerPrototype<?, ?>> byBindingArgClass;
    private final ImmutableMap<Class<?>, DataContainerPrototype<?, ?>> byStreamClass;
    private final ImmutableMap<YangInstanceIdentifier.NodeIdentifier, CodecContextSupplier> byYang;
    private final ImmutableMap<String, ValueNodeCodecContext> leafChild;

    AbstractDataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype, DataContainerAnalysis<T> analysis) {
        super(prototype);
        this.byBindingArgClass = analysis.byBindingArgClass;
        this.byStreamClass = analysis.byStreamClass;
        this.byYang = analysis.byYang;
        this.leafChild = analysis.leafNodes;
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public final DocumentedNode.WithStatus getSchema() {
        return (DocumentedNode.WithStatus)((CommonDataObjectCodecPrototype)this.prototype()).runtimeType().statement();
    }

    @Override
    DataContainerPrototype<?, ?> streamChildPrototype(Class<?> childClass) {
        return (DataContainerPrototype)this.byStreamClass.get(childClass);
    }

    @Override
    public final CommonDataObjectCodecContext<?, ?> bindingPathArgumentChild(DataObjectStep<?> step, List<YangInstanceIdentifier.PathArgument> builder) {
        Class type = step.type();
        DataContainerCodecContext context = (DataContainerCodecContext)this.childNonNull(this.pathChildPrototype(type), type, "Class %s is not valid child of %s", type, this.getBindingClass()).getCodecContext();
        context.addYangPathArgument(step, builder);
        if (context instanceof CommonDataObjectCodecContext) {
            CommonDataObjectCodecContext dataObject = (CommonDataObjectCodecContext)context;
            return dataObject;
        }
        if (context instanceof ChoiceCodecContext) {
            ChoiceCodecContext choice = (ChoiceCodecContext)context;
            return choice.bindingPathArgumentChild((DataObjectStep)step, (List)builder);
        }
        throw new IllegalStateException("Unhandled context " + context);
    }

    @Nullable DataContainerPrototype<?, ?> pathChildPrototype(@NonNull Class<? extends DataObject> argType) {
        return (DataContainerPrototype)this.byBindingArgClass.get(argType);
    }

    @Override
    CodecContextSupplier yangChildSupplier(YangInstanceIdentifier.NodeIdentifier arg) {
        return (CodecContextSupplier)this.byYang.get((Object)arg);
    }

    final ValueNodeCodecContext getLeafChild(String name) {
        ValueNodeCodecContext value = (ValueNodeCodecContext)this.leafChild.get((Object)name);
        if (value == null) {
            throw new IncorrectNestingException("Leaf %s is not valid for %s", new Object[]{name, this.getBindingClass()});
        }
        return value;
    }

    final @NonNull ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifier> byYangKeySet() {
        return this.byYang.keySet();
    }

    abstract @NonNull Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAllAugmentationsFrom(DataContainerNode var1);
}

