/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;

public abstract class AugmentableCodecDataObject<T extends DataObject & Augmentable<T>>
extends CodecDataObject<T>
implements Augmentable<T> {
    private static final VarHandle CACHED_AUGMENTATIONS;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> cachedAugmentations;

    protected AugmentableCodecDataObject(AbstractDataObjectCodecContext<T, ?> context, DataContainerNode data) {
        super(context, data);
    }

    public final <A extends Augmentation<T>> @Nullable A augmentation(Class<A> augmentationType) {
        Object augObj;
        Objects.requireNonNull(augmentationType, "Supplied augmentation must not be null.");
        ImmutableMap<Class<Augmentation<T>>, Augmentation<T>> aug = this.acquireAugmentations();
        if (aug != null) {
            return (A)((Augmentation)aug.get(augmentationType));
        }
        AugmentationCodecContext augCtx = (AugmentationCodecContext)this.codecContext().streamChild(augmentationType);
        if (augCtx != null && augmentationType.isAssignableFrom(augCtx.getBindingClass()) && (augObj = augCtx.filterFrom(this.codecData())) != null) {
            return augObj;
        }
        return null;
    }

    public final ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> augmentations() {
        ImmutableMap<Class<Augmentation<T>>, Augmentation<T>> local = this.acquireAugmentations();
        return local != null ? local : this.loadAugmentations();
    }

    private ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> acquireAugmentations() {
        return CACHED_AUGMENTATIONS.getAcquire(this);
    }

    private @NonNull ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> loadAugmentations() {
        Map<Class<Augmentation<?>>, Augmentation<?>> extracted = this.codecContext().getAllAugmentationsFrom(this.codecData());
        ImmutableMap ret = ImmutableMap.copyOf(extracted);
        Object witness = CACHED_AUGMENTATIONS.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (ImmutableMap)witness;
    }

    static {
        try {
            CACHED_AUGMENTATIONS = MethodHandles.lookup().findVarHandle(AugmentableCodecDataObject.class, "cachedAugmentations", ImmutableMap.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

