/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.AnydataBindingStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafSetNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.MapCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.OpaqueData;
import org.opendaylight.yangtools.yang.binding.OpaqueObject;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

final class BindingToNormalizedStreamWriter
implements AnydataBindingStreamWriter,
Delegator<NormalizedNodeStreamWriter> {
    private final Deque<CodecContext> schema = new ArrayDeque<CodecContext>();
    private final @NonNull NormalizedNodeStreamWriter delegate;
    private final CodecContext rootContext;

    BindingToNormalizedStreamWriter(DataContainerCodecContext<?, ?, ?> rootContext, NormalizedNodeStreamWriter delegate) {
        this.rootContext = Objects.requireNonNull(rootContext);
        this.delegate = Objects.requireNonNull(delegate);
    }

    private void emitSchema(Object schemaNode) {
        this.delegate.nextDataSchemaNode((DataSchemaNode)schemaNode);
    }

    CodecContext current() {
        return this.schema.peek();
    }

    private YangInstanceIdentifier.NodeIdentifier duplicateSchemaEnter() {
        CodecContext current = this.current();
        CodecContext next = current == null ? this.rootContext : current;
        this.schema.push(next);
        return next.getDomPathArgument();
    }

    private <T extends YangInstanceIdentifier.PathArgument> T enter(Class<?> name, Class<T> identifier) {
        CodecContext next;
        CodecContext current = this.current();
        if (current == null) {
            next = this.rootContext;
        } else if (current instanceof DataContainerCodecContext) {
            DataContainerCodecContext currentContainer = (DataContainerCodecContext)current;
            next = currentContainer.getStreamChild(name);
        } else {
            throw new IllegalArgumentException("Could not start node " + name + " in non-container " + current);
        }
        this.schema.push(next);
        return (T)((YangInstanceIdentifier.PathArgument)identifier.cast(next.getDomPathArgument()));
    }

    private <T extends YangInstanceIdentifier.PathArgument> T enter(String localName, Class<T> identifier) {
        CodecContext current = this.current();
        ValueNodeCodecContext next = ((AbstractDataObjectCodecContext)current).getLeafChild(localName);
        this.schema.push(next);
        return (T)((YangInstanceIdentifier.PathArgument)identifier.cast(next.getDomPathArgument()));
    }

    public NormalizedNodeStreamWriter getDelegate() {
        return this.delegate;
    }

    public void endNode() throws IOException {
        CodecContext left = this.schema.pop();
        if (!(left instanceof CaseCodecContext) && !(left instanceof AugmentationCodecContext)) {
            this.delegate.endNode();
        }
    }

    private Map.Entry<YangInstanceIdentifier.NodeIdentifier, Object> serializeLeaf(String localName, Object value) {
        CodecContext current = this.current();
        if (!(current instanceof AbstractDataObjectCodecContext)) {
            throw new IllegalArgumentException("Unexpected current context " + current);
        }
        AbstractDataObjectCodecContext currentCasted = (AbstractDataObjectCodecContext)current;
        ValueNodeCodecContext leafContext = currentCasted.getLeafChild(localName);
        YangInstanceIdentifier.NodeIdentifier domArg = leafContext.getDomPathArgument();
        Object domValue = leafContext.getValueCodec().serialize(value);
        this.emitSchema(leafContext.getSchema());
        return new AbstractMap.SimpleEntry<YangInstanceIdentifier.NodeIdentifier, Object>(domArg, domValue);
    }

    public void leafNode(String localName, Object value) throws IOException {
        Map.Entry<YangInstanceIdentifier.NodeIdentifier, Object> dom = this.serializeLeaf(localName, value);
        this.delegate.startLeafNode(dom.getKey());
        this.delegate.scalarValue(dom.getValue());
        this.delegate.endNode();
    }

    @Override
    public void anydataNode(String name, OpaqueObject<?> value) throws IOException {
        Map.Entry<YangInstanceIdentifier.NodeIdentifier, Object> dom = this.serializeLeaf(name, value);
        if (this.delegate.startAnydataNode(dom.getKey(), ((OpaqueData)value.getValue()).getObjectModel())) {
            this.delegate.scalarValue(dom.getValue());
            this.delegate.endNode();
        }
    }

    public void anyxmlNode(String name, Object value) throws IOException {
        Map.Entry<YangInstanceIdentifier.NodeIdentifier, Object> dom = this.serializeLeaf(name, value);
        if (this.delegate.startAnyxmlNode(dom.getKey(), DOMSource.class)) {
            this.delegate.domSourceValue((DOMSource)dom.getValue());
            this.delegate.endNode();
        }
    }

    public void leafSetEntryNode(Object value) throws IOException {
        LeafSetNodeCodecContext ctx = (LeafSetNodeCodecContext)this.current();
        Object domValue = ctx.getValueCodec().serialize(value);
        this.delegate.startLeafSetEntryNode(new YangInstanceIdentifier.NodeWithValue(ctx.getSchema().getQName(), domValue));
        this.delegate.scalarValue(domValue);
        this.delegate.endNode();
    }

    public void startAugmentationNode(Class<? extends Augmentation<?>> augmentationType) throws IOException {
        this.enter(augmentationType, YangInstanceIdentifier.NodeIdentifier.class);
    }

    public void startCase(Class<? extends DataObject> caze, int childSizeHint) {
        this.enter(caze, YangInstanceIdentifier.NodeIdentifier.class);
    }

    public void startChoiceNode(Class<? extends DataContainer> type, int childSizeHint) throws IOException {
        this.delegate.startChoiceNode(this.enter(type, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startContainerNode(Class<? extends DataObject> object, int childSizeHint) throws IOException {
        this.delegate.startContainerNode(this.enter(object, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startLeafSet(String localName, int childSizeHint) throws IOException {
        YangInstanceIdentifier.NodeIdentifier id = this.enter(localName, YangInstanceIdentifier.NodeIdentifier.class);
        this.emitSchema(this.current().getSchema());
        this.delegate.startLeafSet(id, childSizeHint);
    }

    public void startOrderedLeafSet(String localName, int childSizeHint) throws IOException {
        this.delegate.startOrderedLeafSet(this.enter(localName, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startMapEntryNode(Key<?> key, int childSizeHint) throws IOException {
        this.duplicateSchemaEnter();
        YangInstanceIdentifier.NodeIdentifierWithPredicates identifier = ((MapCodecContext)this.current()).serialize(key);
        this.delegate.startMapEntryNode(identifier, childSizeHint);
    }

    public <T extends DataObject & KeyAware<?>> void startMapNode(Class<T> mapEntryType, int childSizeHint) throws IOException {
        this.delegate.startMapNode(this.enter(mapEntryType, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public <T extends DataObject & KeyAware<?>> void startOrderedMapNode(Class<T> mapEntryType, int childSizeHint) throws IOException {
        this.delegate.startOrderedMapNode(this.enter(mapEntryType, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startUnkeyedList(Class<? extends DataObject> obj, int childSizeHint) throws IOException {
        this.delegate.startUnkeyedList(this.enter(obj, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startUnkeyedListItem(int childSizeHint) throws IOException {
        this.delegate.startUnkeyedListItem(this.duplicateSchemaEnter(), childSizeHint);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

