/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.DataObjectStep;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.AddedByUsesAware;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class CodecItemFactory {
    private static final @NonNull CodecItemFactory DEFAULT = new CodecItemFactory();

    private CodecItemFactory() {
    }

    DataObjectStep<?> createItem(Class<?> childClass, EffectiveStatement<?, ?> childSchema) {
        return InstanceIdentifier.createStep(childClass);
    }

    static @NonNull CodecItemFactory of() {
        return DEFAULT;
    }

    static @NonNull CodecItemFactory of(Class<?> bindingClass) {
        return new Case(bindingClass);
    }

    private static final class Case
    extends CodecItemFactory {
        private final Class<?> bindingClass;

        Case(Class<?> bindingClass) {
            this.bindingClass = Objects.requireNonNull(bindingClass);
        }

        @Override
        DataObjectStep<?> createItem(Class<?> childClass, EffectiveStatement<?, ?> childSchema) {
            AddedByUsesAware aware;
            return childSchema instanceof AddedByUsesAware && (aware = (AddedByUsesAware)childSchema).isAddedByUses() ? InstanceIdentifier.createStep(this.bindingClass, childClass) : super.createItem(childClass, childSchema);
        }
    }
}

