/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataContainerCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.codec.api.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.api.MissingClassInLoadingStrategyException;
import org.opendaylight.mdsal.binding.dom.codec.api.MissingSchemaException;
import org.opendaylight.mdsal.binding.dom.codec.api.MissingSchemaForClassException;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingToNormalizedStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.CachingNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.NonCachingCodec;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectStep;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class DataContainerCodecContext<D extends DataContainer, R extends CompositeRuntimeType, P extends DataContainerPrototype<?, R>>
extends CodecContext
implements BindingDataContainerCodecTreeNode<D> {
    private static final Logger LOG = LoggerFactory.getLogger(DataContainerCodecContext.class);
    private static final VarHandle EVENT_STREAM_SERIALIZER;
    private final @NonNull P prototype;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BindingDataContainerCodecTreeNode.ChildAddressabilitySummary childAddressabilitySummary;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile DataContainerSerializer eventStreamSerializer;

    DataContainerCodecContext(P prototype) {
        this.prototype = (DataContainerPrototype)Objects.requireNonNull(prototype);
        this.childAddressabilitySummary = DataContainerCodecContext.computeChildAddressabilitySummary(((DataContainerPrototype)prototype).runtimeType().statement());
    }

    final @NonNull P prototype() {
        return this.prototype;
    }

    public final Class<D> getBindingClass() {
        return ((DataContainerPrototype)this.prototype()).javaClass();
    }

    @Override
    YangInstanceIdentifier.NodeIdentifier getDomPathArgument() {
        return ((DataContainerPrototype)this.prototype).yangArg();
    }

    public final BindingDataContainerCodecTreeNode.ChildAddressabilitySummary getChildAddressabilitySummary() {
        return this.childAddressabilitySummary;
    }

    public CodecContext yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        CodecContextSupplier supplier;
        if (arg instanceof YangInstanceIdentifier.NodeIdentifier) {
            YangInstanceIdentifier.NodeIdentifier nodeId = (YangInstanceIdentifier.NodeIdentifier)arg;
            supplier = this.yangChildSupplier(nodeId);
        } else if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
            supplier = this.yangChildSupplier(new YangInstanceIdentifier.NodeIdentifier(nip.getNodeType()));
        } else {
            supplier = null;
        }
        return this.childNonNull(supplier, arg, "Argument %s is not valid child of %s", arg, this.getSchema()).getCodecContext();
    }

    abstract @Nullable CodecContextSupplier yangChildSupplier(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier var1);

    public abstract CommonDataObjectCodecContext<?, ?> bindingPathArgumentChild(DataObjectStep<?> var1, List<YangInstanceIdentifier.PathArgument> var2);

    final void addYangPathArgument(DataObjectStep<?> step, List<YangInstanceIdentifier.PathArgument> builder) {
        if (builder != null) {
            this.addYangPathArgument(builder, step);
        }
    }

    void addYangPathArgument(@NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument> builder, DataObjectStep<?> step) {
        YangInstanceIdentifier.NodeIdentifier yangArg = this.getDomPathArgument();
        if (yangArg != null) {
            builder.add((YangInstanceIdentifier.PathArgument)yangArg);
        }
    }

    public final <C extends DataObject> DataContainerCodecContext<C, ?, ?> getStreamChild(Class<C> childClass) {
        return (DataContainerCodecContext)this.childNonNull(this.streamChild((Class)childClass), childClass, "Child %s is not valid child of %s", this.getBindingClass(), childClass);
    }

    public final <C extends DataObject> DataContainerCodecContext<C, ?, ?> streamChild(Class<C> childClass) {
        DataContainerPrototype<C, C> childProto = this.streamChildPrototype(Objects.requireNonNull(childClass));
        return childProto == null ? null : (DataContainerCodecContext)childProto.getCodecContext();
    }

    abstract @Nullable DataContainerPrototype<?, ?> streamChildPrototype(@NonNull Class<?> var1);

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getBindingClass() + "]";
    }

    static final <T extends DataObject, C extends DataContainerCodecContext<T, ?, ?>> @NonNull BindingNormalizedNodeCachingCodec<T> createCachingCodec(C context, ImmutableCollection<Class<? extends BindingObject>> cacheSpecifier) {
        return cacheSpecifier.isEmpty() ? new NonCachingCodec((BindingNormalizedNodeCodec)context) : new CachingNormalizedNodeCodec(context, ImmutableSet.copyOf(cacheSpecifier));
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, YangInstanceIdentifier.PathArgument child, String message, Object ... args) {
        if (nullable == null) {
            throw this.childNullException(child.getNodeType(), message, args);
        }
        return nullable;
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, QName child, String message, Object ... args) {
        if (nullable == null) {
            throw this.childNullException(child, message, args);
        }
        return nullable;
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, Class<?> childClass, String message, Object ... args) {
        if (nullable == null) {
            throw this.childNullException(childClass, message, args);
        }
        return nullable;
    }

    @CheckReturnValue
    private IllegalArgumentException childNullException(QName child, String message, Object ... args) {
        QNameModule module = child.getModule();
        if (!((DataContainerPrototype)this.prototype()).contextFactory().getRuntimeContext().modelContext().findModule(module).isPresent()) {
            return new MissingSchemaException("Module " + module + " is not present in current schema context.");
        }
        return new IncorrectNestingException(message, args);
    }

    @CheckReturnValue
    private @NonNull IllegalArgumentException childNullException(Class<?> childClass, String message, Object ... args) {
        return DataContainerCodecContext.childNullException(((DataContainerPrototype)this.prototype()).contextFactory().getRuntimeContext(), childClass, message, args);
    }

    @CheckReturnValue
    static @NonNull IllegalArgumentException childNullException(BindingRuntimeContext runtimeContext, Class<?> childClass, String message, Object ... args) {
        Object schema = Augmentation.class.isAssignableFrom(childClass) ? runtimeContext.getAugmentationDefinition(childClass.asSubclass(Augmentation.class)) : runtimeContext.getSchemaDefinition(childClass);
        if (schema == null) {
            return new MissingSchemaForClassException(childClass);
        }
        try {
            runtimeContext.loadClass(Type.of(childClass));
        }
        catch (ClassNotFoundException e) {
            return new MissingClassInLoadingStrategyException("User supplied class " + childClass.getName() + " is not available in " + runtimeContext, (Throwable)e);
        }
        return new IncorrectNestingException(message, args);
    }

    final DataContainerSerializer eventStreamSerializer() {
        DataContainerSerializer existing = EVENT_STREAM_SERIALIZER.getAcquire(this);
        return existing != null ? existing : this.loadEventStreamSerializer();
    }

    private DataContainerSerializer loadEventStreamSerializer() {
        DataContainerSerializer loaded = ((DataContainerPrototype)this.prototype()).contextFactory().getEventStreamSerializer(this.getBindingClass());
        Object witness = EVENT_STREAM_SERIALIZER.compareAndExchangeRelease(this, null, loaded);
        return witness == null ? loaded : (DataContainerSerializer)witness;
    }

    final @NonNull NormalizedNode serializeImpl(@NonNull D data) {
        NormalizationResultHolder result = new NormalizationResultHolder();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)result);
        try {
            this.eventStreamSerializer().serialize((DataContainer)data, new BindingToNormalizedStreamWriter(this, domWriter));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize Binding DTO", e);
        }
        return result.getResult().data();
    }

    static final <T extends NormalizedNode> @NonNull T checkDataArgument(@NonNull Class<T> expectedType, NormalizedNode data) {
        try {
            return (T)((NormalizedNode)expectedType.cast(Objects.requireNonNull(data)));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected " + expectedType.getSimpleName(), e);
        }
    }

    static final boolean isSubstitutionFor(Class potential, Class target) {
        HashSet targetImplemented;
        HashSet subImplemented = new HashSet(Arrays.asList(potential.getInterfaces()));
        if (!subImplemented.equals(targetImplemented = new HashSet(Arrays.asList(target.getInterfaces())))) {
            return false;
        }
        if (Augmentation.class.isAssignableFrom(potential) && !DataContainerCodecContext.findAugmentationTarget(potential).equals(DataContainerCodecContext.findAugmentationTarget(target))) {
            return false;
        }
        for (Method potentialMethod : potential.getMethods()) {
            if (Modifier.isStatic(potentialMethod.getModifiers())) continue;
            try {
                Method targetMethod = target.getMethod(potentialMethod.getName(), potentialMethod.getParameterTypes());
                if (potentialMethod.getReturnType().equals(targetMethod.getReturnType())) continue;
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Could not compare methods", e);
            }
        }
        return true;
    }

    static final Class<? extends Augmentable<?>> findAugmentationTarget(Class<? extends Augmentation<?>> augmentation) {
        Optional opt = ClassLoaderUtils.findFirstGenericArgument(augmentation, Augmentation.class);
        return opt.orElse(null);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BindingDataContainerCodecTreeNode.ChildAddressabilitySummary computeChildAddressabilitySummary(Object nodeSchema) {
        if (nodeSchema instanceof DataNodeContainer) {
            DataNodeContainer contaner = (DataNodeContainer)nodeSchema;
            boolean haveAddressable = false;
            boolean haveUnaddressable = false;
            block5: for (DataSchemaNode child : contaner.getChildNodes()) {
                if (child instanceof ContainerSchemaNode || child instanceof AugmentationSchemaNode) {
                    haveAddressable = true;
                    continue;
                }
                if (child instanceof ListSchemaNode) {
                    ListSchemaNode list = (ListSchemaNode)child;
                    if (list.getKeyDefinition().isEmpty()) {
                        haveUnaddressable = true;
                        continue;
                    }
                    haveAddressable = true;
                    continue;
                }
                if (child instanceof AnydataSchemaNode || child instanceof AnyxmlSchemaNode || child instanceof TypedDataSchemaNode) {
                    haveUnaddressable = true;
                    continue;
                }
                if (child instanceof ChoiceSchemaNode) {
                    ChoiceSchemaNode choice = (ChoiceSchemaNode)child;
                    switch (DataContainerCodecContext.computeChildAddressabilitySummary(choice)) {
                        case ADDRESSABLE: {
                            haveAddressable = true;
                            continue block5;
                        }
                        case UNADDRESSABLE: {
                            haveUnaddressable = true;
                            continue block5;
                        }
                        case MIXED: {
                            haveAddressable = true;
                            haveUnaddressable = true;
                            continue block5;
                        }
                    }
                    throw new IllegalStateException("Unhandled accessibility summary for " + child);
                }
                LOG.warn("Unhandled child node {}", (Object)child);
            }
            if (!haveAddressable) {
                return BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
            }
            return haveUnaddressable ? BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.MIXED : BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.ADDRESSABLE;
        }
        if (nodeSchema instanceof ChoiceSchemaNode) {
            ChoiceSchemaNode choice = (ChoiceSchemaNode)nodeSchema;
            return DataContainerCodecContext.computeChildAddressabilitySummary(choice);
        }
        return BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BindingDataContainerCodecTreeNode.ChildAddressabilitySummary computeChildAddressabilitySummary(ChoiceSchemaNode choice) {
        boolean haveAddressable = false;
        boolean haveUnaddressable = false;
        block5: for (CaseSchemaNode child : choice.getCases()) {
            switch (DataContainerCodecContext.computeChildAddressabilitySummary(child)) {
                case ADDRESSABLE: {
                    haveAddressable = true;
                    continue block5;
                }
                case UNADDRESSABLE: {
                    haveUnaddressable = true;
                    continue block5;
                }
                case MIXED: {
                    return BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.MIXED;
                }
            }
            throw new IllegalStateException("Unhandled accessibility summary for " + child);
        }
        if (!haveAddressable) {
            return BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
        }
        return haveUnaddressable ? BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.MIXED : BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.ADDRESSABLE;
    }

    static {
        try {
            EVENT_STREAM_SERIALIZER = MethodHandles.lookup().findVarHandle(DataContainerCodecContext.class, "eventStreamSerializer", DataContainerSerializer.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

